/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.spans.json;

import com.google.gson.stream.JsonWriter;
import com.newrelic.telemetry.json.AttributesJson;
import com.newrelic.telemetry.spans.Span;
import com.newrelic.telemetry.spans.SpanBatch;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class SpanJsonTelemetryBlockWriter {
    private final AttributesJson attributesJson;

    public SpanJsonTelemetryBlockWriter(AttributesJson attributesJson) {
        this.attributesJson = attributesJson;
    }

    public void appendTelemetryJson(SpanBatch batch, JsonWriter jsonWriter) {
        try {
            jsonWriter.name("spans");
            jsonWriter.beginArray();
            Collection telemetry = batch.getTelemetry();
            for (Span span : telemetry) {
                jsonWriter.beginObject();
                jsonWriter.name("id").value(span.getId());
                if (span.getTraceId() != null) {
                    jsonWriter.name("trace.id").value(span.getTraceId());
                }
                jsonWriter.name("timestamp").value(span.getTimestamp());
                jsonWriter.name("attributes").jsonValue(this.attributesJson.toJson(this.enhanceAttributes(span)));
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate span telemetry json", e);
        }
    }

    private Map<String, Object> enhanceAttributes(Span span) {
        HashMap<String, Object> result = new HashMap<String, Object>(span.getAttributes().asMap());
        result.putIfAbsent("name", span.getName());
        result.putIfAbsent("parent.id", span.getParentId());
        result.putIfAbsent("duration.ms", span.getDurationMs());
        result.putIfAbsent("service.name", span.getServiceName());
        if (span.isError()) {
            result.put("error", true);
        }
        return result;
    }

    public AttributesJson getAttributesJson() {
        return this.attributesJson;
    }

    public String toString() {
        return "SpanJsonTelemetryBlockWriter{attributesJson=" + String.valueOf(this.attributesJson) + "}";
    }
}

