/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.EventBatchSenderFactory;
import com.newrelic.telemetry.MetricBatchSenderFactory;
import com.newrelic.telemetry.SpanBatchSenderFactory;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.http.HttpResponse;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpPoster
implements HttpPoster {
    private final OkHttpClient okHttpClient;

    public OkHttpPoster() {
        this(Duration.ofSeconds(2L));
    }

    public OkHttpPoster(Duration callTimeout) {
        this(new OkHttpClient.Builder().callTimeout(callTimeout).build());
    }

    public OkHttpPoster(OkHttpClient client) {
        this.okHttpClient = client;
    }

    public HttpResponse post(URL url, Map<String, String> headers, byte[] body, String mediaType) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)mediaType), (byte[])body);
        Request request = new Request.Builder().url(url).headers(Headers.of(headers)).post(requestBody).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            HttpResponse httpResponse = new HttpResponse(response.body() != null ? response.body().string() : null, response.code(), response.message(), response.headers().toMultimap());
            return httpResponse;
        }
    }

    public static MetricBatchSenderFactory metricSenderFactory() {
        return MetricBatchSenderFactory.fromHttpImplementation(OkHttpPoster::new);
    }

    public static SpanBatchSenderFactory spanSenderFactory() {
        return SpanBatchSenderFactory.fromHttpImplementation(OkHttpPoster::new);
    }

    public static EventBatchSenderFactory eventSenderFactory() {
        return EventBatchSenderFactory.fromHttpImplementation(OkHttpPoster::new);
    }
}

