/*
 * Decompiled with CFR 0.152.
 */
package com.nex3z.flowlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import com.nex3z.flowlayout.R;
import java.util.ArrayList;
import java.util.List;

public class FlowLayout
extends ViewGroup {
    private static final String LOG_TAG = FlowLayout.class.getSimpleName();
    public static final int SPACING_AUTO = -65536;
    public static final int SPACING_ALIGN = -65537;
    private static final int SPACING_UNDEFINED = -65538;
    private static final int UNSPECIFIED_GRAVITY = -1;
    private static final boolean DEFAULT_FLOW = true;
    private static final int DEFAULT_CHILD_SPACING = 0;
    private static final int DEFAULT_CHILD_SPACING_FOR_LAST_ROW = -65538;
    private static final float DEFAULT_ROW_SPACING = 0.0f;
    private static final boolean DEFAULT_RTL = false;
    private static final int DEFAULT_MAX_ROWS = Integer.MAX_VALUE;
    private boolean mFlow = true;
    private int mChildSpacing = 0;
    private int mMinChildSpacing = 0;
    private int mChildSpacingForLastRow = -65538;
    private float mRowSpacing = 0.0f;
    private float mAdjustedRowSpacing = 0.0f;
    private boolean mRtl = false;
    private int mMaxRows = Integer.MAX_VALUE;
    private int mGravity = -1;
    private int mExactMeasuredHeight;
    private List<Float> mHorizontalSpacingForRow = new ArrayList<Float>();
    private List<Integer> mHeightForRow = new ArrayList<Integer>();
    private List<Integer> mWidthForRow = new ArrayList<Integer>();
    private List<Integer> mChildNumForRow = new ArrayList<Integer>();

    public FlowLayout(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FlowLayout, 0, 0);
        try {
            this.mFlow = a.getBoolean(R.styleable.FlowLayout_flFlow, true);
            try {
                this.mChildSpacing = a.getInt(R.styleable.FlowLayout_flChildSpacing, 0);
            }
            catch (NumberFormatException e) {
                this.mChildSpacing = a.getDimensionPixelSize(R.styleable.FlowLayout_flChildSpacing, (int)this.dpToPx(0.0f));
            }
            try {
                this.mMinChildSpacing = a.getInt(R.styleable.FlowLayout_flMinChildSpacing, 0);
            }
            catch (NumberFormatException e) {
                this.mMinChildSpacing = a.getDimensionPixelSize(R.styleable.FlowLayout_flMinChildSpacing, (int)this.dpToPx(0.0f));
            }
            try {
                this.mChildSpacingForLastRow = a.getInt(R.styleable.FlowLayout_flChildSpacingForLastRow, -65538);
            }
            catch (NumberFormatException e) {
                this.mChildSpacingForLastRow = a.getDimensionPixelSize(R.styleable.FlowLayout_flChildSpacingForLastRow, (int)this.dpToPx(0.0f));
            }
            try {
                this.mRowSpacing = a.getInt(R.styleable.FlowLayout_flRowSpacing, 0);
            }
            catch (NumberFormatException e) {
                this.mRowSpacing = a.getDimension(R.styleable.FlowLayout_flRowSpacing, this.dpToPx(0.0f));
            }
            this.mMaxRows = a.getInt(R.styleable.FlowLayout_flMaxRows, Integer.MAX_VALUE);
            this.mRtl = a.getBoolean(R.styleable.FlowLayout_flRtl, false);
            this.mGravity = a.getInt(R.styleable.FlowLayout_android_gravity, -1);
        }
        finally {
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float rowSpacing;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.mHorizontalSpacingForRow.clear();
        this.mHeightForRow.clear();
        this.mWidthForRow.clear();
        this.mChildNumForRow.clear();
        int measuredHeight = 0;
        int measuredWidth = 0;
        int childCount = this.getChildCount();
        int rowWidth = 0;
        int maxChildHeightInRow = 0;
        int childNumInRow = 0;
        int rowSize = widthSize - this.getPaddingLeft() - this.getPaddingRight();
        int rowTotalChildWidth = 0;
        boolean allowFlow = widthMode != 0 && this.mFlow;
        int childSpacing = this.mChildSpacing == -65536 && widthMode == 0 ? 0 : this.mChildSpacing;
        float tmpSpacing = childSpacing == -65536 ? (float)this.mMinChildSpacing : (float)childSpacing;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.LayoutParams childParams = child.getLayoutParams();
            int horizontalMargin = 0;
            int verticalMargin = 0;
            if (childParams instanceof ViewGroup.MarginLayoutParams) {
                this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, measuredHeight);
                ViewGroup.MarginLayoutParams marginParams = (ViewGroup.MarginLayoutParams)childParams;
                horizontalMargin = marginParams.leftMargin + marginParams.rightMargin;
                verticalMargin = marginParams.topMargin + marginParams.bottomMargin;
            } else {
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            }
            int childWidth = child.getMeasuredWidth() + horizontalMargin;
            int childHeight = child.getMeasuredHeight() + verticalMargin;
            if (allowFlow && rowWidth + childWidth > rowSize) {
                this.mHorizontalSpacingForRow.add(Float.valueOf(this.getSpacingForRow(childSpacing, rowSize, rowTotalChildWidth, childNumInRow)));
                this.mChildNumForRow.add(childNumInRow);
                this.mHeightForRow.add(maxChildHeightInRow);
                this.mWidthForRow.add(rowWidth - (int)tmpSpacing);
                if (this.mHorizontalSpacingForRow.size() <= this.mMaxRows) {
                    measuredHeight += maxChildHeightInRow;
                }
                measuredWidth = Math.max(measuredWidth, rowWidth);
                childNumInRow = 1;
                rowWidth = childWidth + (int)tmpSpacing;
                rowTotalChildWidth = childWidth;
                maxChildHeightInRow = childHeight;
                continue;
            }
            ++childNumInRow;
            rowWidth = (int)((float)rowWidth + ((float)childWidth + tmpSpacing));
            rowTotalChildWidth += childWidth;
            maxChildHeightInRow = Math.max(maxChildHeightInRow, childHeight);
        }
        if (this.mChildSpacingForLastRow == -65537) {
            if (this.mHorizontalSpacingForRow.size() >= 1) {
                this.mHorizontalSpacingForRow.add(this.mHorizontalSpacingForRow.get(this.mHorizontalSpacingForRow.size() - 1));
            } else {
                this.mHorizontalSpacingForRow.add(Float.valueOf(this.getSpacingForRow(childSpacing, rowSize, rowTotalChildWidth, childNumInRow)));
            }
        } else if (this.mChildSpacingForLastRow != -65538) {
            this.mHorizontalSpacingForRow.add(Float.valueOf(this.getSpacingForRow(this.mChildSpacingForLastRow, rowSize, rowTotalChildWidth, childNumInRow)));
        } else {
            this.mHorizontalSpacingForRow.add(Float.valueOf(this.getSpacingForRow(childSpacing, rowSize, rowTotalChildWidth, childNumInRow)));
        }
        this.mChildNumForRow.add(childNumInRow);
        this.mHeightForRow.add(maxChildHeightInRow);
        this.mWidthForRow.add(rowWidth - (int)tmpSpacing);
        if (this.mHorizontalSpacingForRow.size() <= this.mMaxRows) {
            measuredHeight += maxChildHeightInRow;
        }
        measuredWidth = Math.max(measuredWidth, rowWidth);
        measuredWidth = childSpacing == -65536 ? widthSize : (widthMode == 0 ? measuredWidth + this.getPaddingLeft() + this.getPaddingRight() : Math.min(measuredWidth + this.getPaddingLeft() + this.getPaddingRight(), widthSize));
        measuredHeight += this.getPaddingTop() + this.getPaddingBottom();
        int rowNum = Math.min(this.mHorizontalSpacingForRow.size(), this.mMaxRows);
        float f = rowSpacing = this.mRowSpacing == -65536.0f && heightMode == 0 ? 0.0f : this.mRowSpacing;
        if (rowSpacing == -65536.0f) {
            this.mAdjustedRowSpacing = rowNum > 1 ? (float)((heightSize - measuredHeight) / (rowNum - 1)) : 0.0f;
            measuredHeight = heightSize;
        } else {
            this.mAdjustedRowSpacing = rowSpacing;
            if (rowNum > 1) {
                measuredHeight = heightMode == 0 ? (int)((float)measuredHeight + this.mAdjustedRowSpacing * (float)(rowNum - 1)) : Math.min((int)((float)measuredHeight + this.mAdjustedRowSpacing * (float)(rowNum - 1)), heightSize);
            }
        }
        this.mExactMeasuredHeight = measuredHeight;
        measuredWidth = widthMode == 0x40000000 ? widthSize : measuredWidth;
        measuredHeight = heightMode == 0x40000000 ? heightSize : measuredHeight;
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int x = this.mRtl ? this.getWidth() - paddingRight : paddingLeft;
        int y = paddingTop;
        int verticalGravity = this.mGravity & 0x70;
        int horizontalGravity = this.mGravity & 7;
        switch (verticalGravity) {
            case 16: {
                int offset = (b - t - paddingTop - paddingBottom - this.mExactMeasuredHeight) / 2;
                y += offset;
                break;
            }
            case 80: {
                int offset = b - t - paddingTop - paddingBottom - this.mExactMeasuredHeight;
                y += offset;
                break;
            }
        }
        int horizontalPadding = paddingLeft + paddingRight;
        int layoutWidth = r - l;
        x += this.getHorizontalGravityOffsetForRow(horizontalGravity, layoutWidth, horizontalPadding, 0);
        int rowCount = this.mChildNumForRow.size();
        int childIdx = 0;
        for (int row = 0; row < rowCount; ++row) {
            int childNum = this.mChildNumForRow.get(row);
            int rowHeight = this.mHeightForRow.get(row);
            float spacing = this.mHorizontalSpacingForRow.get(row).floatValue();
            int i = 0;
            while (i < childNum && childIdx < this.getChildCount()) {
                View child;
                if ((child = this.getChildAt(childIdx++)).getVisibility() == 8) continue;
                ++i;
                ViewGroup.LayoutParams childParams = child.getLayoutParams();
                int marginLeft = 0;
                int marginTop = 0;
                int marginRight = 0;
                if (childParams instanceof ViewGroup.MarginLayoutParams) {
                    ViewGroup.MarginLayoutParams marginParams = (ViewGroup.MarginLayoutParams)childParams;
                    marginLeft = marginParams.leftMargin;
                    marginRight = marginParams.rightMargin;
                    marginTop = marginParams.topMargin;
                }
                int childWidth = child.getMeasuredWidth();
                int childHeight = child.getMeasuredHeight();
                if (this.mRtl) {
                    child.layout(x - marginRight - childWidth, y + marginTop, x - marginRight, y + marginTop + childHeight);
                    x = (int)((float)x - ((float)childWidth + spacing + (float)marginLeft + (float)marginRight));
                    continue;
                }
                child.layout(x + marginLeft, y + marginTop, x + marginLeft + childWidth, y + marginTop + childHeight);
                x = (int)((float)x + ((float)childWidth + spacing + (float)marginLeft + (float)marginRight));
            }
            x = this.mRtl ? this.getWidth() - paddingRight : paddingLeft;
            x += this.getHorizontalGravityOffsetForRow(horizontalGravity, layoutWidth, horizontalPadding, row + 1);
            y = (int)((float)y + ((float)rowHeight + this.mAdjustedRowSpacing));
        }
    }

    private int getHorizontalGravityOffsetForRow(int horizontalGravity, int parentWidth, int horizontalPadding, int row) {
        if (this.mChildSpacing == -65536 || row >= this.mWidthForRow.size() || row >= this.mChildNumForRow.size() || this.mChildNumForRow.get(row) <= 0) {
            return 0;
        }
        int offset = 0;
        switch (horizontalGravity) {
            case 1: {
                offset = (parentWidth - horizontalPadding - this.mWidthForRow.get(row)) / 2;
                break;
            }
            case 5: {
                offset = parentWidth - horizontalPadding - this.mWidthForRow.get(row);
                break;
            }
        }
        return offset;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    public boolean isFlow() {
        return this.mFlow;
    }

    public void setFlow(boolean flow) {
        this.mFlow = flow;
        this.requestLayout();
    }

    public int getChildSpacing() {
        return this.mChildSpacing;
    }

    public void setChildSpacing(int childSpacing) {
        this.mChildSpacing = childSpacing;
        this.requestLayout();
    }

    public int getChildSpacingForLastRow() {
        return this.mChildSpacingForLastRow;
    }

    public void setChildSpacingForLastRow(int childSpacingForLastRow) {
        this.mChildSpacingForLastRow = childSpacingForLastRow;
        this.requestLayout();
    }

    public float getRowSpacing() {
        return this.mRowSpacing;
    }

    public void setRowSpacing(float rowSpacing) {
        this.mRowSpacing = rowSpacing;
        this.requestLayout();
    }

    public int getMaxRows() {
        return this.mMaxRows;
    }

    public void setMaxRows(int maxRows) {
        this.mMaxRows = maxRows;
        this.requestLayout();
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public boolean isRtl() {
        return this.mRtl;
    }

    public void setRtl(boolean rtl) {
        this.mRtl = rtl;
        this.requestLayout();
    }

    public int getMinChildSpacing() {
        return this.mMinChildSpacing;
    }

    public void setMinChildSpacing(int minChildSpacing) {
        this.mMinChildSpacing = minChildSpacing;
        this.requestLayout();
    }

    private float getSpacingForRow(int spacingAttribute, int rowSize, int usedSize, int childNum) {
        float spacing = spacingAttribute == -65536 ? (childNum > 1 ? (float)((rowSize - usedSize) / (childNum - 1)) : 0.0f) : (float)spacingAttribute;
        return spacing;
    }

    private float dpToPx(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

