/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.insight;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.insight.advanced.AdvancedInsightEndpoint;
import com.nexmo.client.insight.advanced.AdvancedInsightRequest;
import com.nexmo.client.insight.advanced.AdvancedInsightResponse;
import com.nexmo.client.insight.basic.BasicInsightEndpoint;
import com.nexmo.client.insight.basic.BasicInsightRequest;
import com.nexmo.client.insight.basic.BasicInsightResponse;
import com.nexmo.client.insight.standard.StandardInsightEndpoint;
import com.nexmo.client.insight.standard.StandardInsightRequest;
import com.nexmo.client.insight.standard.StandardInsightResponse;
import java.io.IOException;

public class InsightClient {
    protected BasicInsightEndpoint basic;
    protected StandardInsightEndpoint standard;
    protected AdvancedInsightEndpoint advanced;

    public InsightClient(HttpWrapper httpWrapper) {
        this.basic = new BasicInsightEndpoint(httpWrapper);
        this.standard = new StandardInsightEndpoint(httpWrapper);
        this.advanced = new AdvancedInsightEndpoint(httpWrapper);
    }

    public BasicInsightResponse getBasicNumberInsight(String number) throws IOException, NexmoClientException {
        return (BasicInsightResponse)this.basic.execute(new BasicInsightRequest(number));
    }

    public BasicInsightResponse getBasicNumberInsight(String number, String country) throws IOException, NexmoClientException {
        return (BasicInsightResponse)this.basic.execute(new BasicInsightRequest(number, country));
    }

    public StandardInsightResponse getStandardNumberInsight(String number) throws IOException, NexmoClientException {
        return (StandardInsightResponse)this.standard.execute(new StandardInsightRequest(number));
    }

    public StandardInsightResponse getStandardNumberInsight(String number, String country) throws IOException, NexmoClientException {
        return (StandardInsightResponse)this.standard.execute(new StandardInsightRequest(number, country));
    }

    public StandardInsightResponse getStandardNumberInsight(String number, String country, boolean cnam) throws IOException, NexmoClientException {
        return (StandardInsightResponse)this.standard.execute(new StandardInsightRequest(number, country, cnam));
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(String number) throws IOException, NexmoClientException {
        return (AdvancedInsightResponse)this.advanced.execute(new AdvancedInsightRequest(number));
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(String number, String country) throws IOException, NexmoClientException {
        return (AdvancedInsightResponse)this.advanced.execute(new AdvancedInsightRequest(number, country));
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(String number, String country, String ipAddress) throws IOException, NexmoClientException {
        return (AdvancedInsightResponse)this.advanced.execute(new AdvancedInsightRequest(number, country, ipAddress));
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(String number, String country, String ipAddress, boolean cnam) throws IOException, NexmoClientException {
        return (AdvancedInsightResponse)this.advanced.execute(new AdvancedInsightRequest(number, country, ipAddress, cnam));
    }
}

