/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.legacyutils;

import com.nexmo.client.NexmoResponseParseException;
import com.nexmo.client.legacyutils.XmlUtil;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class XmlParser {
    private final Lock documentBuilderLock = new ReentrantLock();
    private DocumentBuilder documentBuilder;

    public Document parseXml(String xml) throws NexmoResponseParseException {
        Document doc;
        this.documentBuilderLock.lock();
        try {
            if (this.documentBuilder == null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            doc = XmlUtil.parseXmlString(this.documentBuilder, xml);
        }
        catch (ParserConfigurationException e) {
            throw new NexmoResponseParseException("Exception initialing XML parser", e);
        }
        finally {
            this.documentBuilderLock.unlock();
        }
        return doc;
    }
}

