/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import com.nexmo.client.verify.BaseResult;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class SearchResult
extends BaseResult {
    private final String requestId;
    private final String accountId;
    private final VerificationStatus verificationStatus;
    private final String number;
    private final float price;
    private final String currency;
    private final String senderId;
    private final Date dateSubmitted;
    private final Date dateFinalized;
    private final Date firstEventDate;
    private final Date lastEventDate;
    private final List<VerifyCheck> checks;

    public SearchResult(int status, String requestId, String accountId, VerificationStatus verificationStatus, String number, float price, String currency, String senderId, Date dateSubmitted, Date dateFinalized, Date firstEventDate, Date lastEventDate, List<VerifyCheck> checks, String errorText, boolean temporaryError) {
        super(status, errorText, temporaryError);
        this.requestId = requestId;
        this.accountId = accountId;
        this.verificationStatus = verificationStatus;
        this.number = number;
        this.price = price;
        this.currency = currency;
        this.senderId = senderId;
        this.dateSubmitted = dateSubmitted;
        this.dateFinalized = dateFinalized;
        this.firstEventDate = firstEventDate;
        this.lastEventDate = lastEventDate;
        this.checks = checks;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public VerificationStatus getVerificationStatus() {
        return this.verificationStatus;
    }

    public String getNumber() {
        return this.number;
    }

    public float getPrice() {
        return this.price;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public Date getDateSubmitted() {
        return this.dateSubmitted;
    }

    public Date getDateFinalized() {
        return this.dateFinalized;
    }

    public Date getFirstEventDate() {
        return this.firstEventDate;
    }

    public Date getLastEventDate() {
        return this.lastEventDate;
    }

    public List<VerifyCheck> getChecks() {
        return this.checks;
    }

    public String toString() {
        return "SearchResult [status=" + this.getStatus() + ", requestId=" + this.requestId + ", verificationStatus=" + (Object)((Object)this.verificationStatus) + "]";
    }

    public static enum VerificationStatus {
        IN_PROGRESS("IN PROGRESS"),
        SUCCESS,
        FAILED,
        EXPIRED;

        private final String name;

        private VerificationStatus() {
            this(null);
        }

        private VerificationStatus(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name != null ? this.name : this.name();
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class VerifyCheck
    implements Serializable {
        private static final long serialVersionUID = -5933303841261513099L;
        private final Date date;
        private final String code;
        private final Status status;
        private final String ipAddress;

        public VerifyCheck(Date date, String code, Status status, String ipAddress) {
            this.date = date;
            this.code = code;
            this.status = status;
            this.ipAddress = ipAddress;
        }

        public Date getDate() {
            return this.date;
        }

        public String getCode() {
            return this.code;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String toString() {
            return "VerifyCheck [status=" + (Object)((Object)this.status) + ", code=" + this.code + ", date=" + this.date + "]";
        }

        public static enum Status {
            VALID,
            INVALID;

        }
    }
}

