/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import java.util.Locale;

public class VerifyRequest {
    private final String number;
    private final String brand;
    private final String from;
    private final int length;
    private final Locale locale;
    private final LineType type;

    public VerifyRequest(String number, String brand) {
        this(number, brand, null, -1, null, null);
    }

    public VerifyRequest(String number, String brand, String from) {
        this(number, brand, from, -1, null, null);
    }

    public VerifyRequest(String number, String brand, String from, int length, Locale locale) {
        this(number, brand, from, length, locale, null);
    }

    public VerifyRequest(String number, String brand, String from, int length, Locale locale, LineType type) {
        if (number == null || brand == null) {
            throw new IllegalArgumentException("Number and brand parameters cannot be null.");
        }
        if (length > 0 && length != 4 && length != 6) {
            throw new IllegalArgumentException("Code length must be 4 or 6.");
        }
        this.number = number;
        this.brand = brand;
        this.from = from;
        this.length = length;
        this.locale = locale;
        this.type = type;
    }

    public String getNumber() {
        return this.number;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getFrom() {
        return this.from;
    }

    public int getLength() {
        return this.length;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public LineType getType() {
        return this.type;
    }

    public static enum LineType {
        ALL,
        MOBILE,
        LANDLINE;

    }
}

