/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.NexmoResponseParseException;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.legacyutils.XmlParser;
import com.nexmo.client.verify.VerifyRequest;
import com.nexmo.client.verify.VerifyResult;
import com.nexmo.client.verify.endpoints.SharedParsers;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicNameValuePair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VerifyEndpoint
extends AbstractMethod<VerifyRequest, VerifyResult> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String DEFAULT_URI = "https://api.nexmo.com/verify/xml";
    private XmlParser xmlParser = new XmlParser();
    private String uri = "https://api.nexmo.com/verify/xml";

    public VerifyEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(VerifyRequest request) throws NexmoClientException, UnsupportedEncodingException {
        RequestBuilder result = RequestBuilder.post((String)this.uri).addParameter("number", request.getNumber()).addParameter("brand", request.getBrand());
        if (request.getFrom() != null) {
            result.addParameter("sender_id", request.getFrom());
        }
        if (request.getLength() > 0) {
            result.addParameter("code_length", Integer.toString(request.getLength()));
        }
        if (request.getLocale() != null) {
            result.addParameter((NameValuePair)new BasicNameValuePair("lg", (request.getLocale().getLanguage() + "-" + request.getLocale().getCountry()).toLowerCase()));
        }
        if (request.getType() != null) {
            result.addParameter("require_type", request.getType().toString());
        }
        return result;
    }

    @Override
    public VerifyResult parseResponse(HttpResponse response) throws IOException {
        return this.parseVerifyResponse(new BasicResponseHandler().handleResponse(response));
    }

    public VerifyResult verify(String number, String brand) throws IOException, NexmoClientException {
        return (VerifyResult)this.execute(new VerifyRequest(number, brand));
    }

    public VerifyResult verify(String number, String brand, String from) throws IOException, NexmoClientException {
        return (VerifyResult)this.execute(new VerifyRequest(number, brand, from));
    }

    public VerifyResult verify(String number, String brand, String from, int length, Locale locale) throws IOException, NexmoClientException {
        return (VerifyResult)this.execute(new VerifyRequest(number, brand, from, length, locale));
    }

    public VerifyResult verify(String number, String brand, String from, int length, Locale locale, VerifyRequest.LineType type) throws IOException, NexmoClientException {
        return (VerifyResult)this.execute(new VerifyRequest(number, brand, from, length, locale, type));
    }

    protected VerifyResult parseVerifyResponse(String response) throws NexmoResponseParseException {
        Document doc = this.xmlParser.parseXml(response);
        Element root = doc.getDocumentElement();
        if (!"verify_response".equals(root.getNodeName())) {
            throw new NexmoResponseParseException("No valid response found [ " + response + "] ");
        }
        return SharedParsers.parseVerifyResponseXmlNode(root);
    }
}

