/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.voice.Call;
import com.nexmo.client.voice.CallEvent;
import com.nexmo.client.voice.CallInfo;
import com.nexmo.client.voice.CallInfoPage;
import com.nexmo.client.voice.CallModifier;
import com.nexmo.client.voice.CallsFilter;
import com.nexmo.client.voice.ModifyCallResponse;
import com.nexmo.client.voice.endpoints.CreateCallMethod;
import com.nexmo.client.voice.endpoints.ListCallsMethod;
import com.nexmo.client.voice.endpoints.ModifyCallMethod;
import com.nexmo.client.voice.endpoints.ReadCallMethod;
import java.io.IOException;

public class CallsEndpoint {
    private final CreateCallMethod createCall;
    private final ReadCallMethod readCall;
    private final ListCallsMethod listCalls;
    private final ModifyCallMethod modifyCall;

    public CallsEndpoint(HttpWrapper httpWrapper) {
        this.createCall = new CreateCallMethod(httpWrapper);
        this.readCall = new ReadCallMethod(httpWrapper);
        this.listCalls = new ListCallsMethod(httpWrapper);
        this.modifyCall = new ModifyCallMethod(httpWrapper);
    }

    public CallEvent post(Call callRequest) throws IOException, NexmoClientException {
        return (CallEvent)this.createCall.execute(callRequest);
    }

    public CallInfoPage get(CallsFilter filter) throws IOException, NexmoClientException {
        return (CallInfoPage)this.listCalls.execute(filter);
    }

    public CallInfo get(String uuid) throws IOException, NexmoClientException {
        return (CallInfo)this.readCall.execute(uuid);
    }

    public ModifyCallResponse put(CallModifier modifier) throws IOException, NexmoClientException {
        return (ModifyCallResponse)this.modifyCall.execute(modifier);
    }
}

