/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.JWTAuthMethod;
import com.nexmo.client.voice.CallModifier;
import com.nexmo.client.voice.ModifyCallResponse;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;

public class ModifyCallMethod
extends AbstractMethod<CallModifier, ModifyCallResponse> {
    private static final Log LOG = LogFactory.getLog(ModifyCallMethod.class);
    private static final String DEFAULT_URI = "https://api.nexmo.com/v1/calls/";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};
    private String uri = "https://api.nexmo.com/v1/calls/";

    public ModifyCallMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(CallModifier request) throws NexmoClientException, UnsupportedEncodingException {
        String uri = this.uri + request.getUuid();
        return RequestBuilder.put((String)uri).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(request.toJson()));
    }

    @Override
    public ModifyCallResponse parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return ModifyCallResponse.fromJson(json);
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

