/*
 * Copyright (c) 2011-2017 Nexmo Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.nexmo.client.auth;

import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;

import java.util.List;

public class SignatureAuthMethod extends AbstractAuthMethod {
    public final int SORT_KEY = 20;

    private String apiKey;
    private String secret;

    public SignatureAuthMethod(String apiKey, String secret) {
        this.apiKey = apiKey;
        this.secret = secret;
    }

    @Override
    public RequestBuilder apply(RequestBuilder request) {
        request.addParameter("api_key", apiKey);
        List<NameValuePair> params = request.getParameters();
        RequestSigning.constructSignatureForRequestParameters(params, secret);

        // TODO: This is ugly:
        request.addParameter(params.get(params.size()-1));
        request.addParameter(params.get(params.size()-2));

        return request;
    }

    @Override
    public int getSortKey() {
        return SORT_KEY;
    }
}
