/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.account.AccountClient;
import com.nexmo.client.applications.ApplicationClient;
import com.nexmo.client.auth.AuthMethod;
import com.nexmo.client.auth.JWTAuthMethod;
import com.nexmo.client.auth.NexmoUnacceptableAuthException;
import com.nexmo.client.conversion.ConversionClient;
import com.nexmo.client.insight.InsightClient;
import com.nexmo.client.numbers.NumbersClient;
import com.nexmo.client.sms.SmsClient;
import com.nexmo.client.sns.SnsClient;
import com.nexmo.client.verify.VerifyClient;
import com.nexmo.client.voice.VoiceClient;
import org.apache.http.client.HttpClient;

public class NexmoClient {
    private final AccountClient account;
    private final ApplicationClient application;
    private final InsightClient insight;
    private final NumbersClient numbers;
    private final SmsClient sms;
    private final VoiceClient voice;
    private final VerifyClient verify;
    private final SnsClient sns;
    private final ConversionClient conversion;
    private HttpWrapper httpWrapper;

    public NexmoClient(AuthMethod ... authMethods) {
        this.httpWrapper = new HttpWrapper(authMethods);
        this.account = new AccountClient(this.httpWrapper);
        this.application = new ApplicationClient(this.httpWrapper);
        this.insight = new InsightClient(this.httpWrapper);
        this.numbers = new NumbersClient(this.httpWrapper);
        this.verify = new VerifyClient(this.httpWrapper);
        this.voice = new VoiceClient(this.httpWrapper);
        this.sms = new SmsClient(this.httpWrapper);
        this.sns = new SnsClient(this.httpWrapper);
        this.conversion = new ConversionClient(this.httpWrapper);
    }

    public void setHttpClient(HttpClient client) {
        this.httpWrapper.setHttpClient(client);
    }

    public AccountClient getAccountClient() {
        return this.account;
    }

    public ApplicationClient getApplicationClient() {
        return this.application;
    }

    public InsightClient getInsightClient() {
        return this.insight;
    }

    public NumbersClient getNumbersClient() {
        return this.numbers;
    }

    public SmsClient getSmsClient() {
        return this.sms;
    }

    public SnsClient getSnsClient() {
        return this.sns;
    }

    public VerifyClient getVerifyClient() {
        return this.verify;
    }

    public VoiceClient getVoiceClient() {
        return this.voice;
    }

    public ConversionClient getConversionClient() {
        return this.conversion;
    }

    public String generateJwt() throws NexmoUnacceptableAuthException {
        JWTAuthMethod authMethod = this.httpWrapper.getAuthCollection().getAuth(JWTAuthMethod.class);
        return authMethod.constructToken(System.currentTimeMillis() / 1000L, JWTAuthMethod.constructJTI());
    }
}

