/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.account;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.account.PrefixPricingRequest;
import com.nexmo.client.account.PrefixPricingResponse;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

public class PrefixPricingMethod
extends AbstractMethod<PrefixPricingRequest, PrefixPricingResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String DEFAULT_BASE_URI = "https://rest.nexmo.com/account/get-prefix-pricing/outbound/";
    private String baseUri = "https://rest.nexmo.com/account/get-prefix-pricing/outbound/";

    PrefixPricingMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(PrefixPricingRequest prefixPricingRequest) {
        String uri = this.baseUri + prefixPricingRequest.getServiceType().name().toLowerCase();
        return RequestBuilder.get((String)uri).addParameter("prefix", prefixPricingRequest.getPrefix());
    }

    @Override
    public PrefixPricingResponse parseResponse(HttpResponse response) throws IOException {
        return PrefixPricingResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }
}

