/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.account;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.account.PricingMethod;
import com.nexmo.client.account.PricingRequest;
import com.nexmo.client.account.PricingResponse;
import com.nexmo.client.account.ServiceType;
import com.nexmo.client.account.SmsPricingMethod;
import com.nexmo.client.account.VoicePricingMethod;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class PricingEndpoint {
    private Map<ServiceType, PricingMethod> methods = new HashMap<ServiceType, PricingMethod>();

    PricingEndpoint(HttpWrapper httpWrapper) {
        this.methods.put(ServiceType.SMS, new SmsPricingMethod(httpWrapper));
        this.methods.put(ServiceType.VOICE, new VoicePricingMethod(httpWrapper));
    }

    PricingResponse getPrice(ServiceType serviceType, PricingRequest request) throws IOException, NexmoClientException {
        if (this.methods.containsKey((Object)serviceType)) {
            return (PricingResponse)this.methods.get((Object)serviceType).execute(request);
        }
        throw new IllegalArgumentException("Unknown Service Type: " + (Object)((Object)serviceType));
    }
}

