/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.numbers;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoBadRequestException;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.NexmoMethodFailedException;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.numbers.CancelNumberRequest;
import com.nexmo.client.numbers.CancelNumberResponse;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.util.EntityUtils;

public class CancelNumberEndpoint
extends AbstractMethod<CancelNumberRequest, CancelNumberResponse> {
    private static final String DEFAULT_URI = "https://rest.nexmo.com/number/cancel";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private String uri = "https://rest.nexmo.com/number/cancel";

    public CancelNumberEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(CancelNumberRequest request) throws NexmoClientException, UnsupportedEncodingException {
        RequestBuilder requestBuilder = RequestBuilder.post().setUri(this.uri);
        request.addParams(requestBuilder);
        return requestBuilder;
    }

    @Override
    public CancelNumberResponse parseResponse(HttpResponse response) throws NexmoClientException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 400 || statusCode == 420) {
            throw new NexmoBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        if (statusCode >= 500) {
            throw new NexmoMethodFailedException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        String json = new BasicResponseHandler().handleResponse(response);
        return CancelNumberResponse.fromJson(json);
    }
}

