/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.verify.ControlRequest;
import com.nexmo.client.verify.ControlResponse;
import com.nexmo.client.verify.VerifyException;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

public class ControlEndpoint
extends AbstractMethod<ControlRequest, ControlResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String DEFAULT_URI = "https://api.nexmo.com/verify/control/json";
    private String uri = "https://api.nexmo.com/verify/control/json";

    public ControlEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(ControlRequest request) throws NexmoClientException, UnsupportedEncodingException {
        RequestBuilder requestBuilder = RequestBuilder.post((String)this.uri);
        request.addParams(requestBuilder);
        return requestBuilder;
    }

    @Override
    public ControlResponse parseResponse(HttpResponse response) throws IOException, NexmoClientException {
        ControlResponse controlResponse = ControlResponse.fromJson(new BasicResponseHandler().handleResponse(response));
        if (!controlResponse.getStatus().equals("0")) {
            throw new VerifyException(controlResponse.getStatus(), controlResponse.getErrorText());
        }
        return controlResponse;
    }
}

