/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.nexmo.client.voice.CallOrder;
import com.nexmo.client.voice.CallStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class CallsFilter {
    private CallStatus status;
    private Date dateStart;
    private Date dateEnd;
    private Integer pageSize;
    private Integer recordIndex;
    private CallOrder order;
    private String conversationUuid;

    private CallsFilter(Builder builder) {
        this.status = builder.status;
        this.dateStart = builder.dateStart;
        this.dateEnd = builder.dateEnd;
        this.pageSize = builder.pageSize;
        this.recordIndex = builder.recordIndex;
        this.order = builder.order;
        this.conversationUuid = builder.conversationUuid;
    }

    public CallStatus getStatus() {
        return this.status;
    }

    public Date getDateStart() {
        return this.dateStart;
    }

    public Date getDateEnd() {
        return this.dateEnd;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getRecordIndex() {
        return this.recordIndex;
    }

    public CallOrder getOrder() {
        return this.order;
    }

    public String getConversationUuid() {
        return this.conversationUuid;
    }

    List<NameValuePair> toUrlParams() {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>(10);
        this.conditionalAdd(result, "status", (Object)this.status);
        this.conditionalAdd(result, "date_start", this.dateStart);
        this.conditionalAdd(result, "date_end", this.dateEnd);
        this.conditionalAdd(result, "page_size", this.pageSize);
        this.conditionalAdd(result, "record_index", this.recordIndex);
        this.conditionalAdd(result, "order", this.order != null ? this.order.getCallOrder() : null);
        this.conditionalAdd(result, "conversation_uuid", this.conversationUuid);
        return result;
    }

    private void conditionalAdd(List<NameValuePair> params, String name, String value) {
        if (value != null) {
            params.add((NameValuePair)new BasicNameValuePair(name, value));
        }
    }

    private void conditionalAdd(List<NameValuePair> params, String name, Date value) {
        if (value != null) {
            params.add((NameValuePair)new BasicNameValuePair(name, ISO8601Utils.format((Date)value)));
        }
    }

    private void conditionalAdd(List<NameValuePair> params, String name, Object value) {
        if (value != null) {
            params.add((NameValuePair)new BasicNameValuePair(name, value.toString()));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CallStatus status;
        private Date dateStart;
        private Date dateEnd;
        private Integer pageSize;
        private Integer recordIndex;
        private CallOrder order;
        private String conversationUuid;

        public Builder status(CallStatus status) {
            this.status = status;
            return this;
        }

        public Builder dateStart(Date dateStart) {
            this.dateStart = dateStart;
            return this;
        }

        public Builder dateEnd(Date dateEnd) {
            this.dateEnd = dateEnd;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder recordIndex(Integer recordIndex) {
            this.recordIndex = recordIndex;
            return this;
        }

        public Builder order(CallOrder order) {
            this.order = order;
            return this;
        }

        public Builder conversationUuid(String conversationUuid) {
            this.conversationUuid = conversationUuid;
            return this;
        }

        public CallsFilter build() {
            return new CallsFilter(this);
        }
    }
}

