/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.verify.Psd2Request;
import com.nexmo.client.verify.VerifyResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

public class Psd2Method
extends AbstractMethod<Psd2Request, VerifyResponse> {
    private static final Log LOG = LogFactory.getLog(Psd2Method.class);
    private static final String PATH = "/verify/psd2/json";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};

    public Psd2Method(HttpWrapper wrapper) {
        super(wrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(Psd2Request request) throws UnsupportedEncodingException {
        RequestBuilder builder = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH)).addParameter("number", request.getNumber()).addParameter("payee", request.getPayee()).addParameter("amount", Double.toString(request.getAmount()));
        if (request.getWorkflow() != null) {
            builder.addParameter("workflow_id", Integer.toString(request.getWorkflow().getId()));
        }
        this.optionalParams(builder, "code_length", request.getLength());
        this.optionalParams(builder, "lg", request.getDashedLocale());
        this.optionalParams(builder, "country", request.getCountry());
        this.optionalParams(builder, "pin_expiry", request.getPinExpiry());
        this.optionalParams(builder, "next_event_wait", request.getNextEventWait());
        return builder;
    }

    @Override
    public VerifyResponse parseResponse(HttpResponse response) throws IOException {
        return VerifyResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }

    private RequestBuilder optionalParams(RequestBuilder builder, String paramName, Object value) {
        if (value != null) {
            builder.addParameter(paramName, value + "");
        }
        return null;
    }
}

