/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.verify.VerifyRequest;
import com.nexmo.client.verify.VerifyResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicNameValuePair;

class VerifyMethod
extends AbstractMethod<VerifyRequest, VerifyResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/verify/json";

    VerifyMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(VerifyRequest request) throws UnsupportedEncodingException {
        RequestBuilder result = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH)).addParameter("number", request.getNumber()).addParameter("brand", request.getBrand());
        if (request.getFrom() != null) {
            result.addParameter("sender_id", request.getFrom());
        }
        if (request.getLength() != null && request.getLength() > 0) {
            result.addParameter("code_length", Integer.toString(request.getLength()));
        }
        if (request.getLocale() != null) {
            result.addParameter((NameValuePair)new BasicNameValuePair("lg", request.getDashedLocale()));
        }
        if (request.getType() != null) {
            result.addParameter("require_type", request.getType().toString());
        }
        if (request.getCountry() != null) {
            result.addParameter("country", request.getCountry());
        }
        if (request.getPinExpiry() != null) {
            result.addParameter("pin_expiry", request.getPinExpiry().toString());
        }
        if (request.getNextEventWait() != null) {
            result.addParameter("next_event_wait", request.getNextEventWait().toString());
        }
        if (request.getWorkflow() != null) {
            result.addParameter("workflow_id", String.valueOf(request.getWorkflow().getId()));
        }
        return result;
    }

    @Override
    public VerifyResponse parseResponse(HttpResponse response) throws IOException {
        return VerifyResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }
}

