/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum VoiceName {
    ADITI("Aditi"),
    AGNIESZKA("Agnieszka"),
    ALVA("Alva"),
    AMY("Amy"),
    ASTRID("Astrid"),
    BIANCA("Bianca"),
    BRIAN("Brian"),
    CARLA("Carla"),
    CARMEN("Carmen"),
    CARMIT("Carmit"),
    CATARINA("Catarina"),
    CELINE("Celine"),
    CEM("Cem"),
    CHANTAL("Chantal"),
    CHIPMUNK("Chipmunk"),
    CONCHITA("Conchita"),
    CRISTIANO("Cristiano"),
    DAMAYANTI("Damayanti"),
    EMPAR("Empar"),
    DORA("Dora"),
    EMMA("Emma"),
    ENRIQUE("Enrique"),
    ERIC("Eric"),
    EWA("Ewa"),
    FELIPE("Felipe"),
    FILIZ("Filiz"),
    GERAINT("Geraint"),
    GIORGIO("Giorgio"),
    GWYNETH("Gwyneth"),
    HANS("Hans"),
    HENRIK("Henrik"),
    INES("Ines"),
    IOANA("Ioana"),
    IVETA("Iveta"),
    IVY("Ivy"),
    JACEK("Jacek"),
    JAN("Jan"),
    JENNIFER("Jennifer"),
    JOANA("Joana"),
    JOEY("Joey"),
    JORDI("Jordi"),
    JUSTIN("Justin"),
    KANYA("Kanya"),
    KARL("Karl"),
    KENDRA("Kendra"),
    KIMBERLY("Kimberly"),
    LAILA("Laila"),
    LAURA("Laura"),
    LEA("Lea"),
    LEKHA("Lekha"),
    LIV("Liv"),
    LOTTE("Lotte"),
    LUCIA("Lucia"),
    LUCIANA("Luciana"),
    MADS("Mads"),
    MAGED("Maged"),
    MAJA("Maja"),
    MARISKA("Mariska"),
    MARLENE("Marlene"),
    MATHIEU("Mathieu"),
    MATTHEW("Matthew"),
    MAXIM("Maxim"),
    MEI_JIA("Mei-Jia"),
    MELINA("Melina"),
    MIA("Mia"),
    MIGUEL("Miguel"),
    MIREN("Miren"),
    MIZUKI("Mizuki"),
    MONTSERRAT("Montserrat"),
    NAJA("Naja"),
    NICOLE("Nicole"),
    NIKOS("Nikos"),
    NORA("Nora"),
    OSKAR("Oskar"),
    PENELOPE("Penelope"),
    RAVEENA("Raveena"),
    RICARDO("Ricardo"),
    RUBEN("Ruben"),
    RUSSELL("Russell"),
    SALLI("Salli"),
    SATU("Satu"),
    SEOYEON("Seoyeon"),
    SIN_JI("Sin-Ji"),
    SORA("Sora"),
    TAKUMI("Takumi"),
    TARIK("Tarik"),
    TATYANA("Tatyana"),
    TESSA("Tessa"),
    TIAN_TIAN("Tian-Tian"),
    VICKI("Vicki"),
    VITORIA("Vitoria"),
    YELDA("Yelda"),
    ZEINA("Zeina"),
    ZHIYU("Zhiyu"),
    ZUZANA("Zuzana"),
    UNKNOWN("Unknown");

    private static final Map<String, VoiceName> voiceNameIndex;
    private String displayName;

    private VoiceName(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        return this.displayName;
    }

    @JsonCreator
    public static VoiceName fromString(String name) {
        VoiceName foundVoiceName = voiceNameIndex.get(name.toUpperCase());
        return foundVoiceName != null ? foundVoiceName : UNKNOWN;
    }

    @JsonValue
    public String getDisplayName() {
        return this.displayName;
    }

    static {
        voiceNameIndex = new HashMap<String, VoiceName>();
        for (VoiceName voiceName : VoiceName.values()) {
            voiceNameIndex.put(voiceName.name(), voiceName);
        }
    }
}

