/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.nexmo.client.voice.ncco.Action;
import com.nexmo.client.voice.ncco.EventMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class NotifyAction
implements Action {
    private static final String ACTION = "notify";
    private Map<String, ?> payload;
    private Collection<String> eventUrl;
    private EventMethod eventMethod;

    private NotifyAction(Builder builder) {
        this.payload = builder.payload;
        this.eventUrl = builder.eventUrl;
        this.eventMethod = builder.eventMethod;
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    public Map getPayload() {
        return this.payload;
    }

    public Collection<String> getEventUrl() {
        return this.eventUrl;
    }

    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    public static Builder builder(Map<String, ?> payload, Collection<String> eventUrl) {
        return new Builder(payload, eventUrl);
    }

    public static Builder builder(Map<String, ?> payload, String ... eventUrl) {
        return new Builder(payload, eventUrl);
    }

    public static class Builder {
        private Map<String, ?> payload;
        private Collection<String> eventUrl;
        private EventMethod eventMethod = null;

        public Builder(Map<String, ?> payload, Collection<String> eventUrl) {
            this.payload = payload;
            this.eventUrl = eventUrl;
        }

        public Builder(Map<String, ?> payload, String ... eventUrl) {
            this(payload, Arrays.asList(eventUrl));
        }

        public Builder payload(Map<String, ?> payload) {
            this.payload = payload;
            return this;
        }

        public Builder eventUrl(Collection<String> eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventUrl(String ... eventUrl) {
            return this.eventUrl(Arrays.asList(eventUrl));
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public NotifyAction build() {
            return new NotifyAction(this);
        }
    }
}

