/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.application;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoBadRequestException;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.application.ApplicationList;
import com.nexmo.client.application.ListApplicationRequest;
import com.nexmo.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.util.EntityUtils;

class ListApplicationsMethod
extends AbstractMethod<ListApplicationRequest, ApplicationList> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/applications";

    ListApplicationsMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(ListApplicationRequest request) throws UnsupportedEncodingException {
        RequestBuilder builder = RequestBuilder.get((String)(this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v2") + PATH)).setHeader("Content-Type", "application/json");
        if (request != null) {
            if (request.getPageSize() > 0L) {
                builder.addParameter("page_size", String.valueOf(request.getPageSize()));
            }
            if (request.getPage() > 0L) {
                builder.addParameter("page", String.valueOf(request.getPage()));
            }
        }
        return builder;
    }

    @Override
    public ApplicationList parseResponse(HttpResponse response) throws IOException, NexmoClientException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NexmoBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return ApplicationList.fromJson(new BasicResponseHandler().handleResponse(response));
    }

    @Override
    protected RequestBuilder applyAuth(RequestBuilder request) throws NexmoClientException {
        return this.getAuthMethod(this.getAcceptableAuthMethods()).applyAsBasicAuth(request);
    }
}

