/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.application;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoBadRequestException;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.application.Application;
import com.nexmo.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.util.EntityUtils;

class UpdateApplicationMethod
extends AbstractMethod<Application, Application> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/applications/%s";

    UpdateApplicationMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(Application application) throws UnsupportedEncodingException {
        return RequestBuilder.put((String)(this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v2") + String.format(PATH, application.getId()))).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(application.toJson()));
    }

    @Override
    public Application parseResponse(HttpResponse response) throws IOException, NexmoClientException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NexmoBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return Application.fromJson(new BasicResponseHandler().handleResponse(response));
    }

    @Override
    protected RequestBuilder applyAuth(RequestBuilder request) throws NexmoClientException {
        return this.getAuthMethod(this.getAcceptableAuthMethods()).applyAsBasicAuth(request);
    }
}

