/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import com.fasterxml.jackson.annotation.JsonValue;
import com.nexmo.client.verify.BaseRequest;
import java.util.Locale;

public class Psd2Request
extends BaseRequest {
    private Double amount;
    private String payee;
    private Workflow workflow;

    private Psd2Request(Builder builder) {
        super(builder.number, builder.length, builder.locale, builder.country, builder.pinExpiry, builder.nextEventWait);
        this.amount = builder.amount;
        this.payee = builder.payee;
        this.workflow = builder.workflow;
    }

    public Double getAmount() {
        return this.amount;
    }

    public String getPayee() {
        return this.payee;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public static Builder builder(String number, Double amount, String payee) {
        return new Builder(number, amount, payee);
    }

    @Override
    public String toString() {
        return "Psd2Request{" + super.toString() + ", amount=" + this.amount + ", payee='" + this.payee + '\'' + ", workflow=" + (Object)((Object)this.workflow) + '}';
    }

    public static class Builder {
        private Double amount;
        private String payee;
        private Workflow workflow;
        private String number;
        private Locale locale;
        private Integer length;
        private Integer pinExpiry;
        private Integer nextEventWait;
        private String country;

        public Builder(String number, Double amount, String payee) {
            this.number = number;
            this.payee = payee;
            this.amount = amount;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public Builder pinExpiry(Integer pinExpiry) {
            this.pinExpiry = pinExpiry;
            return this;
        }

        public Builder nextEventWait(Integer nextEventWait) {
            this.nextEventWait = nextEventWait;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Psd2Request build() {
            return new Psd2Request(this);
        }
    }

    public static enum Workflow {
        SMS_TTS_TTS(1),
        SMS_SMS_TTS(2),
        TTS_TTS(3),
        SMS_SMS(4),
        SMS_TTS(5),
        SMS(6),
        TTS(7);

        private final int id;

        private Workflow(int id) {
            this.id = id;
        }

        @JsonValue
        public int getId() {
            return this.id;
        }
    }
}

