/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.jwt;

import com.nexmo.jwt.Jwt;
import com.nexmo.jwt.KeyConverter;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J=\u0010\r\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0010\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/nexmo/jwt/JwtGenerator;", "", "keyConverter", "Lcom/nexmo/jwt/KeyConverter;", "(Lcom/nexmo/jwt/KeyConverter;)V", "addRequiredNonExistentClaims", "", "claims", "", "", "jwtBuilder", "Lio/jsonwebtoken/JwtBuilder;", "convertUserSuppliedDateClaimsToEpoch", "convertZonedDateTimesToLong", "builder", "keys", "", "(Ljava/util/Map;Lio/jsonwebtoken/JwtBuilder;[Ljava/lang/String;)V", "generate", "jwt", "Lcom/nexmo/jwt/Jwt;"})
public final class JwtGenerator {
    private final KeyConverter keyConverter;

    @NotNull
    public final String generate(@NotNull Jwt jwt) {
        Intrinsics.checkParameterIsNotNull((Object)jwt, (String)"jwt");
        RSAPrivateKey privateKey = this.keyConverter.privateKey(jwt.getPrivateKeyContents());
        JwtBuilder jwtBuilder = Jwts.builder().setHeaderParam("type", (Object)"JWT").claim("application_id", (Object)jwt.getApplicationId()).addClaims(jwt.getClaims());
        Map<String, Object> map = jwt.getClaims();
        JwtBuilder jwtBuilder2 = jwtBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)jwtBuilder2, (String)"jwtBuilder");
        this.addRequiredNonExistentClaims(map, jwtBuilder2);
        this.convertUserSuppliedDateClaimsToEpoch(jwt.getClaims(), jwtBuilder);
        String string = jwtBuilder.signWith((Key)privateKey, SignatureAlgorithm.RS256).compact();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jwtBuilder.signWith(priv\u2026lgorithm.RS256).compact()");
        return string;
    }

    private final void addRequiredNonExistentClaims(Map<String, ? extends Object> claims, JwtBuilder jwtBuilder) {
        if (!claims.containsKey("iat")) {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            jwtBuilder.claim("iat", (Object)instant.getEpochSecond());
        }
        if (!claims.containsKey("jti")) {
            jwtBuilder.claim("jti", (Object)UUID.randomUUID().toString());
        }
    }

    private final void convertUserSuppliedDateClaimsToEpoch(Map<String, ? extends Object> claims, JwtBuilder jwtBuilder) {
        this.convertZonedDateTimesToLong(claims, jwtBuilder, "iat", "exp", "nbf");
    }

    /*
     * WARNING - void declaration
     */
    private final void convertZonedDateTimesToLong(Map<String, ? extends Object> claims, JwtBuilder builder, String ... keys) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map map;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Map<String, ? extends Object> map2 = claims;
        JwtBuilder jwtBuilder = builder;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var9_10 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_10.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(ArraysKt.contains((Object[])keys, it.getKey()) && it.getValue() instanceof ZonedDateTime)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = map = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$filterTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Map.Entry element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            it = element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl3 = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry = element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            boolean bl4 = false;
            Object v = it2.getValue();
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.time.ZonedDateTime");
            }
            Long l = ((ZonedDateTime)v).toEpochSecond();
            map.put(k2, l);
        }
        map = destination$iv$iv;
        jwtBuilder.addClaims(map);
    }

    public JwtGenerator(@NotNull KeyConverter keyConverter) {
        Intrinsics.checkParameterIsNotNull((Object)keyConverter, (String)"keyConverter");
        this.keyConverter = keyConverter;
    }

    public /* synthetic */ JwtGenerator(KeyConverter keyConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            keyConverter = new KeyConverter(null, 1, null);
        }
        this(keyConverter);
    }

    public JwtGenerator() {
        this(null, 1, null);
    }
}

