/*
 * Decompiled with CFR 0.152.
 */
package com.nfl.graphql.mediator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.nfl.graphql.mediator.glitr.type.GlitrScalars;
import graphql.Scalars;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class GraphQLMediator {
    private static final String NAME = "name";
    private static final String OBJECT_KIND = "OBJECT";
    private static final String ENUM_KIND = "ENUM";
    private final Map<String, JsonNode> jsonMap;
    private Map<String, GraphQLOutputType> builtObjects = new HashMap<String, GraphQLOutputType>(89);

    public GraphQLMediator(String rawJson) {
        JsonNode root;
        ObjectMapper mapper = new ObjectMapper();
        try {
            root = mapper.readTree(rawJson);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        ArrayNode typesMap = (ArrayNode)root.get("data").get("__schema").get("types");
        this.jsonMap = new HashMap<String, JsonNode>(typesMap.size() * 7);
        typesMap.spliterator().forEachRemaining(jsonNode -> this.jsonMap.put(jsonNode.get(NAME).textValue(), (JsonNode)jsonNode));
    }

    public GraphQLOutputType retrieveOutputDescription(String typeName) {
        return this.retrieveOutputDescription(typeName, Collections.emptySet());
    }

    private GraphQLOutputType retrieveOutputDescription(String typeName, Set<String> undefinedTypes) {
        if (!this.builtObjects.containsKey(typeName) && !undefinedTypes.contains(typeName)) {
            HashSet<String> moreUndefined = new HashSet<String>(undefinedTypes);
            moreUndefined.add(typeName);
            GraphQLOutputType newlyBuilt = this.build(typeName, moreUndefined);
            this.builtObjects.put(typeName, newlyBuilt);
        }
        return this.builtObjects.get(typeName);
    }

    private GraphQLOutputType build(String typeName, Set<String> undefinedTypes) {
        if (!this.jsonMap.containsKey(typeName)) {
            throw new UnsupportedOperationException("Asked to map an unknown type: " + typeName);
        }
        JsonNode typeNode = this.jsonMap.get(typeName);
        switch (typeNode.get("kind").asText()) {
            case "OBJECT": {
                List<GraphQLFieldDefinition> fields = this.buildFields((ArrayNode)typeNode.get("fields"), undefinedTypes);
                return new GraphQLObjectType(typeName, typeNode.get("description").asText(), fields, Collections.emptyList());
            }
            case "ENUM": {
                GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum().name(typeName);
                this.deriveEnumValues((ArrayNode)typeNode.get("enumValues"), builder);
                return builder.build();
            }
        }
        throw new UnsupportedOperationException();
    }

    private void deriveEnumValues(ArrayNode enumValues, GraphQLEnumType.Builder builder) {
        enumValues.spliterator().forEachRemaining(valueNode -> builder.value(valueNode.get(NAME).asText()));
    }

    private List<GraphQLFieldDefinition> buildFields(ArrayNode typeNode, Set<String> undefinedTypes) {
        LinkedList<GraphQLFieldDefinition> schemaDefFields = new LinkedList<GraphQLFieldDefinition>();
        typeNode.spliterator().forEachRemaining(this.buildFieldDefinition(undefinedTypes, schemaDefFields));
        return schemaDefFields;
    }

    private Consumer<JsonNode> buildFieldDefinition(Set<String> undefinedTypes, List<GraphQLFieldDefinition> schemaDefFields) {
        return jsonNode -> {
            String name = jsonNode.get(NAME).asText();
            String desc = jsonNode.get("description").asText();
            GraphQLOutputType type = this.deriveType(jsonNode.get("type"), undefinedTypes);
            if (type != null) {
                GraphQLFieldDefinition typeField = GraphQLFieldDefinition.newFieldDefinition().type(type).name(name).description(desc).build();
                schemaDefFields.add(typeField);
            }
        };
    }

    private GraphQLOutputType deriveType(JsonNode type, Set<String> undefinedTypes) {
        String kind = type.get("kind").asText();
        String typeName = type.get(NAME).asText();
        switch (kind) {
            case "NON_NULL": {
                GraphQLOutputType derived = this.deriveType(type.get("ofType"), undefinedTypes);
                if (derived == null) {
                    return null;
                }
                return new GraphQLNonNull((GraphQLType)derived);
            }
            case "ENUM": 
            case "OBJECT": {
                return this.retrieveOutputDescription(typeName, undefinedTypes);
            }
            case "SCALAR": {
                return this.scalarType(typeName);
            }
            case "LIST": {
                GraphQLOutputType derivedForList = this.deriveType(type.get("ofType"), undefinedTypes);
                if (derivedForList == null) {
                    return null;
                }
                return new GraphQLList((GraphQLType)derivedForList);
            }
            case "INTERFACE": {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unknown kind:" + kind);
    }

    private GraphQLOutputType scalarType(String typeName) {
        switch (typeName) {
            case "ID": {
                return Scalars.GraphQLID;
            }
            case "String": {
                return Scalars.GraphQLString;
            }
            case "DateTime": {
                return GlitrScalars.GraphQLDateTime;
            }
            case "Date": {
                return GlitrScalars.GraphQLDate;
            }
            case "Int": {
                return Scalars.GraphQLInt;
            }
            case "Long": {
                return Scalars.GraphQLLong;
            }
            case "Boolean": {
                return Scalars.GraphQLBoolean;
            }
            case "Float": {
                return Scalars.GraphQLFloat;
            }
            case "BigInteger": {
                return Scalars.GraphQLBigInteger;
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + typeName);
    }
}

