/*
 * Decompiled with CFR 0.152.
 */
package com.nfl.graphql.mediator.glitr.type;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class GlitrScalars {
    private static final String UTC = "UTC";
    private static final String SHIELD_DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private static final String SHIELD_LOCAL_DATE_PATTERN = "yyyy-MM-dd";
    public static final GraphQLScalarType GraphQLDateTime = new GraphQLScalarType("DateTime", "DateTime is represented in UTC with the following template: 2014-08-20T18:00:00.000Z", new Coercing(){

        public Object serialize(Object input) {
            if (input == null) {
                return null;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(GlitrScalars.SHIELD_DATE_TIME_PATTERN).withZone(ZoneId.of(GlitrScalars.UTC));
            if (input instanceof ZonedDateTime) {
                ZonedDateTime time = (ZonedDateTime)input;
                return time.format(formatter);
            }
            if (input instanceof Instant) {
                Instant time = (Instant)input;
                return formatter.format(time);
            }
            throw new IllegalArgumentException("Can't serialize type " + input.getClass() + " with value " + input.toString());
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            String encodedDateTime = ((StringValue)input).getValue();
            return Instant.parse(encodedDateTime);
        }
    });
    public static final GraphQLScalarType GraphQLDate = new GraphQLScalarType("Date", "Date represents a local date without any timezone information therefore should only be used for displaying purposes. The template is 2014-08-20", new Coercing(){

        public Object serialize(Object input) {
            if (input == null) {
                return null;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(GlitrScalars.SHIELD_LOCAL_DATE_PATTERN).withZone(ZoneId.of(GlitrScalars.UTC));
            if (input instanceof LocalDate) {
                LocalDate time = (LocalDate)input;
                return time.format(formatter);
            }
            if (input instanceof ZonedDateTime) {
                ZonedDateTime time = (ZonedDateTime)input;
                return time.format(formatter);
            }
            if (input instanceof Instant) {
                Instant time = (Instant)input;
                return formatter.format(time);
            }
            throw new IllegalArgumentException("Can't serialize type " + input.getClass() + " with value " + input.toString());
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            String encodedDateTime = ((StringValue)input).getValue();
            return LocalDate.parse(encodedDateTime);
        }
    });
}

