/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.nhaarman.listviewanimations.BaseAdapterDecorator;
import com.nhaarman.listviewanimations.itemmanipulation.TouchEventHandler;
import com.nhaarman.listviewanimations.itemmanipulation.animateaddition.AnimateAdditionAdapter;
import com.nhaarman.listviewanimations.itemmanipulation.dragdrop.DragAndDropHandler;
import com.nhaarman.listviewanimations.itemmanipulation.dragdrop.DraggableManager;
import com.nhaarman.listviewanimations.itemmanipulation.dragdrop.DynamicListViewWrapper;
import com.nhaarman.listviewanimations.itemmanipulation.dragdrop.OnItemMovedListener;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.DismissableManager;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.OnDismissCallback;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.SwipeDismissTouchListener;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.SwipeTouchListener;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.SwipeUndoAdapter;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.SwipeUndoTouchListener;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.UndoCallback;
import com.nhaarman.listviewanimations.util.Insertable;
import com.nhaarman.listviewanimations.util.ListViewWrapper;
import java.util.Collection;
import java.util.HashSet;

public class DynamicListView
extends ListView {
    @NonNull
    private final MyOnScrollListener mMyOnScrollListener = new MyOnScrollListener();
    @Nullable
    private DragAndDropHandler mDragAndDropHandler;
    @Nullable
    private SwipeTouchListener mSwipeTouchListener;
    @Nullable
    private TouchEventHandler mCurrentHandlingTouchEventHandler;
    @Nullable
    private AnimateAdditionAdapter<Object> mAnimateAdditionAdapter;
    @Nullable
    private SwipeUndoAdapter mSwipeUndoAdapter;

    public DynamicListView(@NonNull Context context) {
        this(context, null);
    }

    public DynamicListView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, Resources.getSystem().getIdentifier("listViewStyle", "attr", "android"));
    }

    public DynamicListView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        super.setOnScrollListener((AbsListView.OnScrollListener)this.mMyOnScrollListener);
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        if (onTouchListener instanceof SwipeTouchListener) {
            return;
        }
        super.setOnTouchListener(onTouchListener);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener onScrollListener) {
        this.mMyOnScrollListener.addOnScrollListener(onScrollListener);
    }

    public void enableDragAndDrop() {
        if (Build.VERSION.SDK_INT < 14) {
            throw new UnsupportedOperationException("Drag and drop is only supported API levels 14 and up!");
        }
        this.mDragAndDropHandler = new DragAndDropHandler(this);
    }

    public void disableDragAndDrop() {
        this.mDragAndDropHandler = null;
    }

    public void enableSwipeToDismiss(@NonNull OnDismissCallback onDismissCallback) {
        this.mSwipeTouchListener = new SwipeDismissTouchListener(new DynamicListViewWrapper(this), onDismissCallback);
    }

    public void enableSwipeUndo(@NonNull UndoCallback undoCallback) {
        this.mSwipeTouchListener = new SwipeUndoTouchListener((ListViewWrapper)new DynamicListViewWrapper(this), undoCallback);
    }

    public void enableSimpleSwipeUndo() {
        if (this.mSwipeUndoAdapter == null) {
            throw new IllegalStateException("enableSimpleSwipeUndo requires a SwipeUndoAdapter to be set as an adapter");
        }
        this.mSwipeTouchListener = new SwipeUndoTouchListener((ListViewWrapper)new DynamicListViewWrapper(this), this.mSwipeUndoAdapter.getUndoCallback());
        this.mSwipeUndoAdapter.setSwipeUndoTouchListener((SwipeUndoTouchListener)this.mSwipeTouchListener);
    }

    public void disableSwipeToDismiss() {
        this.mSwipeTouchListener = null;
    }

    public void setAdapter(ListAdapter adapter) {
        Object wrappedAdapter = adapter;
        this.mSwipeUndoAdapter = null;
        if (adapter instanceof BaseAdapter) {
            BaseAdapter rootAdapter = (BaseAdapter)wrappedAdapter;
            while (rootAdapter instanceof BaseAdapterDecorator) {
                if (rootAdapter instanceof SwipeUndoAdapter) {
                    this.mSwipeUndoAdapter = (SwipeUndoAdapter)rootAdapter;
                }
                rootAdapter = ((BaseAdapterDecorator)rootAdapter).getDecoratedBaseAdapter();
            }
            if (rootAdapter instanceof Insertable) {
                this.mAnimateAdditionAdapter = new AnimateAdditionAdapter((BaseAdapter)wrappedAdapter);
                this.mAnimateAdditionAdapter.setListView(this);
                wrappedAdapter = this.mAnimateAdditionAdapter;
            }
        }
        super.setAdapter(wrappedAdapter);
        if (this.mDragAndDropHandler != null) {
            this.mDragAndDropHandler.setAdapter(adapter);
        }
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent ev) {
        if (this.mCurrentHandlingTouchEventHandler == null) {
            boolean firstTimeInteracting = false;
            if (!(this.mSwipeTouchListener instanceof SwipeUndoTouchListener && ((SwipeUndoTouchListener)this.mSwipeTouchListener).hasPendingItems() || this.mDragAndDropHandler == null)) {
                this.mDragAndDropHandler.onTouchEvent(ev);
                firstTimeInteracting = this.mDragAndDropHandler.isInteracting();
                if (firstTimeInteracting) {
                    this.mCurrentHandlingTouchEventHandler = this.mDragAndDropHandler;
                    this.sendCancelEvent(this.mSwipeTouchListener, ev);
                }
            }
            if (this.mCurrentHandlingTouchEventHandler == null && this.mSwipeTouchListener != null) {
                this.mSwipeTouchListener.onTouchEvent(ev);
                firstTimeInteracting = this.mSwipeTouchListener.isInteracting();
                if (firstTimeInteracting) {
                    this.mCurrentHandlingTouchEventHandler = this.mSwipeTouchListener;
                    this.sendCancelEvent(this.mDragAndDropHandler, ev);
                }
            }
            if (firstTimeInteracting) {
                MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)ev);
                cancelEvent.setAction(3);
                super.onTouchEvent(cancelEvent);
            }
            return firstTimeInteracting || super.dispatchTouchEvent(ev);
        }
        return this.onTouchEvent(ev);
    }

    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        if (this.mCurrentHandlingTouchEventHandler != null) {
            this.mCurrentHandlingTouchEventHandler.onTouchEvent(ev);
        }
        if (ev.getActionMasked() == 1 || ev.getActionMasked() == 3) {
            this.mCurrentHandlingTouchEventHandler = null;
        }
        return this.mCurrentHandlingTouchEventHandler != null || super.onTouchEvent(ev);
    }

    private void sendCancelEvent(@Nullable TouchEventHandler touchEventHandler, @NonNull MotionEvent motionEvent) {
        if (touchEventHandler != null) {
            MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
            cancelEvent.setAction(3);
            touchEventHandler.onTouchEvent(cancelEvent);
        }
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mDragAndDropHandler != null) {
            this.mDragAndDropHandler.dispatchDraw(canvas);
        }
    }

    public int computeVerticalScrollOffset() {
        return super.computeVerticalScrollOffset();
    }

    public int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    public int computeVerticalScrollRange() {
        return super.computeVerticalScrollRange();
    }

    public void insert(int index, Object item) {
        if (this.mAnimateAdditionAdapter == null) {
            throw new IllegalStateException("Adapter should implement Insertable!");
        }
        this.mAnimateAdditionAdapter.insert(index, item);
    }

    public void insert(int index, Object ... items) {
        if (this.mAnimateAdditionAdapter == null) {
            throw new IllegalStateException("Adapter should implement Insertable!");
        }
        this.mAnimateAdditionAdapter.insert(index, (Object[])items);
    }

    public <T> void insert(Pair<Integer, T> ... indexItemPairs) {
        if (this.mAnimateAdditionAdapter == null) {
            throw new IllegalStateException("Adapter should implement Insertable!");
        }
        this.mAnimateAdditionAdapter.insert(indexItemPairs);
    }

    public <T> void insert(@NonNull Iterable<Pair<Integer, T>> indexItemPairs) {
        if (this.mAnimateAdditionAdapter == null) {
            throw new IllegalStateException("Adapter should implement Insertable!");
        }
        this.mAnimateAdditionAdapter.insert(indexItemPairs);
    }

    public void setDraggableManager(@NonNull DraggableManager draggableManager) {
        if (this.mDragAndDropHandler != null) {
            this.mDragAndDropHandler.setDraggableManager(draggableManager);
        }
    }

    public void setOnItemMovedListener(@Nullable OnItemMovedListener onItemMovedListener) {
        if (this.mDragAndDropHandler != null) {
            this.mDragAndDropHandler.setOnItemMovedListener(onItemMovedListener);
        }
    }

    public void startDragging(int position) {
        if (this.mSwipeTouchListener instanceof SwipeUndoTouchListener && ((SwipeUndoTouchListener)this.mSwipeTouchListener).hasPendingItems()) {
            return;
        }
        if (this.mDragAndDropHandler != null) {
            this.mDragAndDropHandler.startDragging(position);
        }
    }

    public void setScrollSpeed(float speed) {
        if (this.mDragAndDropHandler != null) {
            this.mDragAndDropHandler.setScrollSpeed(speed);
        }
    }

    public void setDismissableManager(@Nullable DismissableManager dismissableManager) {
        if (this.mSwipeTouchListener != null) {
            this.mSwipeTouchListener.setDismissableManager(dismissableManager);
        }
    }

    public void fling(int position) {
        if (this.mSwipeTouchListener != null) {
            this.mSwipeTouchListener.fling(position);
        }
    }

    public void setSwipeTouchChild(int childResId) {
        if (this.mSwipeTouchListener != null) {
            this.mSwipeTouchListener.setTouchChild(childResId);
        }
    }

    public void setMinimumAlpha(float minimumAlpha) {
        if (this.mSwipeTouchListener != null) {
            this.mSwipeTouchListener.setMinimumAlpha(minimumAlpha);
        }
    }

    public void dismiss(int position) {
        if (this.mSwipeTouchListener != null) {
            if (this.mSwipeTouchListener instanceof SwipeDismissTouchListener) {
                ((SwipeDismissTouchListener)this.mSwipeTouchListener).dismiss(position);
            } else {
                throw new IllegalStateException("Enabled swipe functionality does not support dismiss");
            }
        }
    }

    public void undo(@NonNull View view) {
        if (this.mSwipeTouchListener != null) {
            if (this.mSwipeTouchListener instanceof SwipeUndoTouchListener) {
                ((SwipeUndoTouchListener)this.mSwipeTouchListener).undo(view);
            } else {
                throw new IllegalStateException("Enabled swipe functionality does not support undo");
            }
        }
    }

    private class MyOnScrollListener
    implements AbsListView.OnScrollListener {
        private final Collection<AbsListView.OnScrollListener> mOnScrollListeners = new HashSet<AbsListView.OnScrollListener>();

        private MyOnScrollListener() {
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            for (AbsListView.OnScrollListener onScrollListener : this.mOnScrollListeners) {
                onScrollListener.onScrollStateChanged(view, scrollState);
            }
            if (scrollState == 1 && DynamicListView.this.mSwipeTouchListener instanceof SwipeUndoTouchListener) {
                ((SwipeUndoTouchListener)DynamicListView.this.mSwipeTouchListener).dimissPending();
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            for (AbsListView.OnScrollListener onScrollListener : this.mOnScrollListeners) {
                onScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        }

        public void addOnScrollListener(AbsListView.OnScrollListener onScrollListener) {
            this.mOnScrollListeners.add(onScrollListener);
        }
    }
}

