/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.animateaddition;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import com.nhaarman.listviewanimations.BaseAdapterDecorator;
import com.nhaarman.listviewanimations.itemmanipulation.animateaddition.InsertQueue;
import com.nhaarman.listviewanimations.util.AbsListViewWrapper;
import com.nhaarman.listviewanimations.util.Insertable;
import com.nhaarman.listviewanimations.util.ListViewWrapper;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class AnimateAdditionAdapter<T>
extends BaseAdapterDecorator {
    private static final long DEFAULT_SCROLLDOWN_ANIMATION_MS = 300L;
    private long mScrolldownAnimationDurationMs = 300L;
    private static final long DEFAULT_INSERTION_ANIMATION_MS = 300L;
    private long mInsertionAnimationDurationMs = 300L;
    private static final String ALPHA = "alpha";
    @NonNull
    private final Insertable<T> mInsertable;
    @NonNull
    private final InsertQueue<T> mInsertQueue;
    private boolean mShouldAnimateDown = true;

    public AnimateAdditionAdapter(@NonNull BaseAdapter baseAdapter) {
        super(baseAdapter);
        BaseAdapter rootAdapter = this.getRootAdapter();
        if (!(rootAdapter instanceof Insertable)) {
            throw new IllegalArgumentException("BaseAdapter should implement Insertable!");
        }
        this.mInsertable = (Insertable)rootAdapter;
        this.mInsertQueue = new InsertQueue<T>(this.mInsertable);
    }

    @Deprecated
    public void setAbsListView(@NonNull AbsListView absListView) {
        if (!(absListView instanceof ListView)) {
            throw new IllegalArgumentException("AnimateAdditionAdapter requires a ListView!");
        }
        this.setListView((ListView)absListView);
    }

    public void setListView(@NonNull ListView listView) {
        this.setListViewWrapper((ListViewWrapper)new AbsListViewWrapper((AbsListView)listView));
    }

    public void setShouldAnimateDown(boolean shouldAnimateDown) {
        this.mShouldAnimateDown = shouldAnimateDown;
    }

    public void setScrolldownAnimationDuration(long scrolldownAnimationDurationMs) {
        this.mScrolldownAnimationDurationMs = scrolldownAnimationDurationMs;
    }

    public void setInsertionAnimationDuration(long insertionAnimationDurationMs) {
        this.mInsertionAnimationDurationMs = insertionAnimationDurationMs;
    }

    public void insert(int index, @NonNull T item) {
        this.insert(new Pair((Object)index, item));
    }

    public void insert(int index, T ... items) {
        Pair[] pairs = new Pair[items.length];
        for (int i = 0; i < items.length; ++i) {
            pairs[i] = new Pair((Object)(index + i), items[i]);
        }
        this.insert(pairs);
    }

    public void insert(Pair<Integer, T> ... indexItemPairs) {
        this.insert(Arrays.asList(indexItemPairs));
    }

    public void insert(@NonNull Iterable<Pair<Integer, T>> indexItemPairs) {
        if (this.getListViewWrapper() == null) {
            throw new IllegalStateException("Call setListView on this AnimateAdditionAdapter!");
        }
        ArrayList visibleViews = new ArrayList();
        ArrayList<Integer> insertedPositions = new ArrayList<Integer>();
        ArrayList<Integer> insertedBelowPositions = new ArrayList<Integer>();
        int scrollDistance = 0;
        int numInsertedAbove = 0;
        for (Pair<Integer, T> pair : indexItemPairs) {
            int insertedPosition;
            Iterator i$;
            int index;
            if (this.getListViewWrapper().getFirstVisiblePosition() > (Integer)pair.first) {
                index = (Integer)pair.first;
                i$ = insertedPositions.iterator();
                while (i$.hasNext()) {
                    insertedPosition = (Integer)i$.next();
                    if (index < insertedPosition) continue;
                    ++index;
                }
                this.mInsertable.add(index, pair.second);
                insertedPositions.add(index);
                ++numInsertedAbove;
                if (!this.mShouldAnimateDown) continue;
                View view = this.getView((Integer)pair.first, null, this.getListViewWrapper().getListView());
                view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                scrollDistance -= view.getMeasuredHeight();
                continue;
            }
            if (this.getListViewWrapper().getLastVisiblePosition() >= (Integer)pair.first || this.getListViewWrapper().getLastVisiblePosition() == -1 || !this.childrenFillAbsListView()) {
                index = (Integer)pair.first;
                i$ = insertedPositions.iterator();
                while (i$.hasNext()) {
                    insertedPosition = (Integer)i$.next();
                    if (index < insertedPosition) continue;
                    ++index;
                }
                Pair newPair = new Pair((Object)index, pair.second);
                visibleViews.add(newPair);
                continue;
            }
            index = (Integer)pair.first;
            i$ = insertedPositions.iterator();
            while (i$.hasNext()) {
                insertedPosition = (Integer)i$.next();
                if (index < insertedPosition) continue;
                ++index;
            }
            i$ = insertedBelowPositions.iterator();
            while (i$.hasNext()) {
                int queuedPosition = (Integer)i$.next();
                if (index < queuedPosition) continue;
                ++index;
            }
            insertedBelowPositions.add(index);
            this.mInsertable.add(index, pair.second);
        }
        if (this.mShouldAnimateDown) {
            ((AbsListView)this.getListViewWrapper().getListView()).smoothScrollBy(scrollDistance, (int)(this.mScrolldownAnimationDurationMs * (long)numInsertedAbove));
        }
        this.mInsertQueue.insert(visibleViews);
        int firstVisiblePosition = this.getListViewWrapper().getFirstVisiblePosition();
        View firstChild = this.getListViewWrapper().getChildAt(0);
        int childTop = firstChild == null ? 0 : firstChild.getTop();
        ((ListView)this.getListViewWrapper().getListView()).setSelectionFromTop(firstVisiblePosition + numInsertedAbove, childTop);
    }

    private boolean childrenFillAbsListView() {
        if (this.getListViewWrapper() == null) {
            throw new IllegalStateException("Call setListView on this AnimateAdditionAdapter first!");
        }
        int childrenHeight = 0;
        for (int i = 0; i < this.getListViewWrapper().getCount(); ++i) {
            View child = this.getListViewWrapper().getChildAt(i);
            if (child == null) continue;
            childrenHeight += child.getHeight();
        }
        return this.getListViewWrapper().getListView().getHeight() <= childrenHeight;
    }

    @NonNull
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        View view = super.getView(position, convertView, parent);
        if (this.mInsertQueue.getActiveIndexes().contains(position)) {
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-1, (int)Integer.MIN_VALUE);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
            view.measure(widthMeasureSpec, heightMeasureSpec);
            int originalHeight = view.getMeasuredHeight();
            ValueAnimator heightAnimator = ValueAnimator.ofInt((int[])new int[]{1, originalHeight});
            heightAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new HeightUpdater(view));
            Animator[] customAnimators = this.getAdditionalAnimators(view, parent);
            Animator[] animators = new Animator[customAnimators.length + 1];
            animators[0] = heightAnimator;
            System.arraycopy(customAnimators, 0, animators, 1, customAnimators.length);
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(animators);
            ViewHelper.setAlpha((View)view, (float)0.0f);
            ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)view, (String)ALPHA, (float[])new float[]{0.0f, 1.0f});
            AnimatorSet allAnimatorsSet = new AnimatorSet();
            allAnimatorsSet.playSequentially(new Animator[]{animatorSet, alphaAnimator});
            allAnimatorsSet.setDuration(this.mInsertionAnimationDurationMs);
            allAnimatorsSet.addListener((Animator.AnimatorListener)new ExpandAnimationListener(position));
            allAnimatorsSet.start();
        }
        return view;
    }

    @NonNull
    protected Animator[] getAdditionalAnimators(@NonNull View view, @NonNull ViewGroup parent) {
        return new Animator[0];
    }

    private class ExpandAnimationListener
    extends AnimatorListenerAdapter {
        private final int mPosition;

        ExpandAnimationListener(int position) {
            this.mPosition = position;
        }

        public void onAnimationEnd(Animator animation) {
            AnimateAdditionAdapter.this.mInsertQueue.removeActiveIndex(this.mPosition);
        }
    }

    private static class HeightUpdater
    implements ValueAnimator.AnimatorUpdateListener {
        private final View mView;

        HeightUpdater(View view) {
            this.mView = view;
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            ViewGroup.LayoutParams layoutParams = this.mView.getLayoutParams();
            layoutParams.height = (Integer)animation.getAnimatedValue();
            this.mView.setLayoutParams(layoutParams);
        }
    }
}

