/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.dragdrop;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.WrapperListAdapter;
import com.nhaarman.listviewanimations.itemmanipulation.DynamicListView;
import com.nhaarman.listviewanimations.itemmanipulation.TouchEventHandler;
import com.nhaarman.listviewanimations.itemmanipulation.dragdrop.DragAndDropListViewWrapper;
import com.nhaarman.listviewanimations.itemmanipulation.dragdrop.DraggableManager;
import com.nhaarman.listviewanimations.itemmanipulation.dragdrop.DynamicListViewWrapper;
import com.nhaarman.listviewanimations.itemmanipulation.dragdrop.HoverDrawable;
import com.nhaarman.listviewanimations.itemmanipulation.dragdrop.OnItemMovedListener;
import com.nhaarman.listviewanimations.util.Swappable;

@TargetApi(value=14)
public class DragAndDropHandler
implements TouchEventHandler {
    private static final int INVALID_ID = -1;
    @NonNull
    private final DragAndDropListViewWrapper mWrapper;
    @NonNull
    private final ScrollHandler mScrollHandler;
    @NonNull
    private final SwitchViewAnimator mSwitchViewAnimator;
    private final int mSlop;
    @Nullable
    private ListAdapter mAdapter;
    @Nullable
    private HoverDrawable mHoverDrawable;
    @Nullable
    private View mMobileView;
    private long mMobileItemId;
    private float mLastMotionEventY = -1.0f;
    private int mOriginalMobileItemPosition = -1;
    @NonNull
    private DraggableManager mDraggableManager;
    @Nullable
    private OnItemMovedListener mOnItemMovedListener;
    private float mDownX;
    private float mDownY;
    private boolean mIsSettlingHoverDrawable;

    public DragAndDropHandler(@NonNull DynamicListView dynamicListView) {
        this(new DynamicListViewWrapper(dynamicListView));
    }

    public DragAndDropHandler(@NonNull DragAndDropListViewWrapper dragAndDropListViewWrapper) {
        this.mWrapper = dragAndDropListViewWrapper;
        if (this.mWrapper.getAdapter() != null) {
            this.setAdapterInternal(this.mWrapper.getAdapter());
        }
        this.mScrollHandler = new ScrollHandler();
        this.mWrapper.setOnScrollListener(this.mScrollHandler);
        this.mDraggableManager = new DefaultDraggableManager();
        this.mSwitchViewAnimator = Build.VERSION.SDK_INT <= 19 ? new KitKatSwitchViewAnimator() : new LSwitchViewAnimator();
        this.mMobileItemId = -1L;
        ViewConfiguration vc = ViewConfiguration.get((Context)dragAndDropListViewWrapper.getListView().getContext());
        this.mSlop = vc.getScaledTouchSlop();
    }

    public void setAdapter(@NonNull ListAdapter adapter) {
        this.setAdapterInternal(adapter);
    }

    private void setAdapterInternal(@NonNull ListAdapter adapter) {
        ListAdapter actualAdapter = adapter;
        if (actualAdapter instanceof WrapperListAdapter) {
            actualAdapter = ((WrapperListAdapter)actualAdapter).getWrappedAdapter();
        }
        if (!actualAdapter.hasStableIds()) {
            throw new IllegalStateException("Adapter doesn't have stable ids! Make sure your adapter has stable ids, and override hasStableIds() to return true.");
        }
        if (!(actualAdapter instanceof Swappable)) {
            throw new IllegalArgumentException("Adapter should implement Swappable!");
        }
        this.mAdapter = actualAdapter;
    }

    public void setScrollSpeed(float speed) {
        this.mScrollHandler.setScrollSpeed(speed);
    }

    public void startDragging(int position) {
        if (this.mMobileItemId != -1L) {
            return;
        }
        if (this.mLastMotionEventY < 0.0f) {
            throw new IllegalStateException("User must be touching the DynamicListView!");
        }
        if (this.mAdapter == null) {
            throw new IllegalStateException("This DynamicListView has no adapter set!");
        }
        if (position < 0 || position >= this.mAdapter.getCount()) {
            return;
        }
        this.mMobileView = this.mWrapper.getChildAt(position - this.mWrapper.getFirstVisiblePosition() + this.mWrapper.getHeaderViewsCount());
        if (this.mMobileView != null) {
            this.mOriginalMobileItemPosition = position;
            this.mMobileItemId = this.mAdapter.getItemId(position);
            this.mHoverDrawable = new HoverDrawable(this.mMobileView, this.mLastMotionEventY);
            this.mMobileView.setVisibility(4);
        }
    }

    public void setDraggableManager(@NonNull DraggableManager draggableManager) {
        this.mDraggableManager = draggableManager;
    }

    public void setOnItemMovedListener(@Nullable OnItemMovedListener onItemMovedListener) {
        this.mOnItemMovedListener = onItemMovedListener;
    }

    @Override
    public boolean isInteracting() {
        return this.mMobileItemId != -1L;
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean handled = false;
        if (!this.mIsSettlingHoverDrawable) {
            switch (event.getAction() & 0xFF) {
                case 0: {
                    this.mLastMotionEventY = event.getY();
                    handled = this.handleDownEvent(event);
                    break;
                }
                case 2: {
                    this.mLastMotionEventY = event.getY();
                    handled = this.handleMoveEvent(event);
                    break;
                }
                case 1: {
                    handled = this.handleUpEvent();
                    this.mLastMotionEventY = -1.0f;
                    break;
                }
                case 3: {
                    handled = this.handleCancelEvent();
                    this.mLastMotionEventY = -1.0f;
                    break;
                }
                default: {
                    handled = false;
                }
            }
        }
        return handled;
    }

    private boolean handleDownEvent(@NonNull MotionEvent event) {
        this.mDownX = event.getRawX();
        this.mDownY = event.getRawY();
        return true;
    }

    private int getPositionForId(long itemId) {
        View v = this.getViewForId(itemId);
        if (v == null) {
            return -1;
        }
        return this.mWrapper.getPositionForView(v);
    }

    @Nullable
    private View getViewForId(long itemId) {
        ListAdapter adapter = this.mAdapter;
        if (itemId == -1L || adapter == null) {
            return null;
        }
        int firstVisiblePosition = this.mWrapper.getFirstVisiblePosition();
        View result = null;
        for (int i = 0; i < this.mWrapper.getChildCount() && result == null; ++i) {
            long id;
            int position = firstVisiblePosition + i;
            if (position - this.mWrapper.getHeaderViewsCount() < 0 || (id = adapter.getItemId(position - this.mWrapper.getHeaderViewsCount())) != itemId) continue;
            result = this.mWrapper.getChildAt(i);
        }
        return result;
    }

    private boolean handleMoveEvent(@NonNull MotionEvent event) {
        boolean handled = false;
        float deltaX = event.getRawX() - this.mDownX;
        float deltaY = event.getRawY() - this.mDownY;
        if (this.mHoverDrawable == null && Math.abs(deltaY) > (float)this.mSlop && Math.abs(deltaY) > Math.abs(deltaX)) {
            int position = this.mWrapper.pointToPosition((int)event.getX(), (int)event.getY());
            if (position != -1) {
                View downView = this.mWrapper.getChildAt(position - this.mWrapper.getFirstVisiblePosition());
                assert (downView != null);
                if (this.mDraggableManager.isDraggable(downView, position - this.mWrapper.getHeaderViewsCount(), event.getX() - downView.getX(), event.getY() - downView.getY())) {
                    this.startDragging(position - this.mWrapper.getHeaderViewsCount());
                    handled = true;
                }
            }
        } else if (this.mHoverDrawable != null) {
            this.mHoverDrawable.handleMoveEvent(event);
            this.switchIfNecessary();
            this.mWrapper.getListView().invalidate();
            handled = true;
        }
        return handled;
    }

    private void switchIfNecessary() {
        if (this.mHoverDrawable == null || this.mAdapter == null) {
            return;
        }
        int position = this.getPositionForId(this.mMobileItemId);
        long aboveItemId = position - 1 - this.mWrapper.getHeaderViewsCount() >= 0 ? this.mAdapter.getItemId(position - 1 - this.mWrapper.getHeaderViewsCount()) : -1L;
        long belowItemId = position + 1 - this.mWrapper.getHeaderViewsCount() < this.mAdapter.getCount() ? this.mAdapter.getItemId(position + 1 - this.mWrapper.getHeaderViewsCount()) : -1L;
        long switchId = this.mHoverDrawable.isMovingUpwards() ? aboveItemId : belowItemId;
        View switchView = this.getViewForId(switchId);
        int deltaY = this.mHoverDrawable.getDeltaY();
        if (switchView != null && Math.abs(deltaY) > this.mHoverDrawable.getIntrinsicHeight()) {
            this.switchViews(switchView, switchId, this.mHoverDrawable.getIntrinsicHeight() * (deltaY < 0 ? -1 : 1));
        }
        this.mScrollHandler.handleMobileCellScroll();
        this.mWrapper.getListView().invalidate();
    }

    private void switchViews(View switchView, long switchId, float translationY) {
        assert (this.mHoverDrawable != null);
        assert (this.mAdapter != null);
        assert (this.mMobileView != null);
        int switchViewPosition = this.mWrapper.getPositionForView(switchView);
        int mobileViewPosition = this.mWrapper.getPositionForView(this.mMobileView);
        ((Swappable)this.mAdapter).swapItems(switchViewPosition - this.mWrapper.getHeaderViewsCount(), mobileViewPosition - this.mWrapper.getHeaderViewsCount());
        ((BaseAdapter)this.mAdapter).notifyDataSetChanged();
        this.mHoverDrawable.shift(switchView.getHeight());
        this.mSwitchViewAnimator.animateSwitchView(switchId, translationY);
    }

    private boolean handleUpEvent() {
        if (this.mMobileView == null) {
            return false;
        }
        assert (this.mHoverDrawable != null);
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.mHoverDrawable.getTop(), (int)this.mMobileView.getY()});
        SettleHoverDrawableAnimatorListener listener = new SettleHoverDrawableAnimatorListener(this.mHoverDrawable, this.mMobileView);
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)listener);
        valueAnimator.addListener((Animator.AnimatorListener)listener);
        valueAnimator.start();
        int newPosition = this.getPositionForId(this.mMobileItemId) - this.mWrapper.getHeaderViewsCount();
        if (this.mOriginalMobileItemPosition != newPosition && this.mOnItemMovedListener != null) {
            this.mOnItemMovedListener.onItemMoved(this.mOriginalMobileItemPosition, newPosition);
        }
        return true;
    }

    private boolean handleCancelEvent() {
        return this.handleUpEvent();
    }

    public void dispatchDraw(@NonNull Canvas canvas) {
        if (this.mHoverDrawable != null) {
            this.mHoverDrawable.draw(canvas);
        }
    }

    private class SettleHoverDrawableAnimatorListener
    extends AnimatorListenerAdapter
    implements ValueAnimator.AnimatorUpdateListener {
        @NonNull
        private final HoverDrawable mAnimatingHoverDrawable;
        @NonNull
        private final View mAnimatingMobileView;

        private SettleHoverDrawableAnimatorListener(@NonNull HoverDrawable animatingHoverDrawable, View animatingMobileView) {
            this.mAnimatingHoverDrawable = animatingHoverDrawable;
            this.mAnimatingMobileView = animatingMobileView;
        }

        public void onAnimationStart(Animator animation) {
            DragAndDropHandler.this.mIsSettlingHoverDrawable = true;
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            this.mAnimatingHoverDrawable.setTop((Integer)animation.getAnimatedValue());
            DragAndDropHandler.this.mWrapper.getListView().postInvalidate();
        }

        public void onAnimationEnd(Animator animation) {
            this.mAnimatingMobileView.setVisibility(0);
            DragAndDropHandler.this.mHoverDrawable = null;
            DragAndDropHandler.this.mMobileView = null;
            DragAndDropHandler.this.mMobileItemId = -1L;
            DragAndDropHandler.this.mOriginalMobileItemPosition = -1;
            DragAndDropHandler.this.mIsSettlingHoverDrawable = false;
        }
    }

    private class ScrollHandler
    implements AbsListView.OnScrollListener {
        private static final int SMOOTH_SCROLL_DP = 3;
        private final int mSmoothScrollPx;
        private float mScrollSpeedFactor = 1.0f;
        private int mPreviousFirstVisibleItem = -1;
        private int mPreviousLastVisibleItem = -1;
        private int mCurrentFirstVisibleItem;
        private int mCurrentLastVisibleItem;

        ScrollHandler() {
            Resources r = DragAndDropHandler.this.mWrapper.getListView().getResources();
            this.mSmoothScrollPx = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)r.getDisplayMetrics());
        }

        void setScrollSpeed(float scrollSpeedFactor) {
            this.mScrollSpeedFactor = scrollSpeedFactor;
        }

        void handleMobileCellScroll() {
            if (DragAndDropHandler.this.mHoverDrawable == null || DragAndDropHandler.this.mIsSettlingHoverDrawable) {
                return;
            }
            Rect r = DragAndDropHandler.this.mHoverDrawable.getBounds();
            int offset = DragAndDropHandler.this.mWrapper.computeVerticalScrollOffset();
            int height = DragAndDropHandler.this.mWrapper.getListView().getHeight();
            int extent = DragAndDropHandler.this.mWrapper.computeVerticalScrollExtent();
            int range = DragAndDropHandler.this.mWrapper.computeVerticalScrollRange();
            int hoverViewTop = r.top;
            int hoverHeight = r.height();
            int scrollPx = (int)Math.max(1.0f, (float)this.mSmoothScrollPx * this.mScrollSpeedFactor);
            if (hoverViewTop <= 0 && offset > 0) {
                DragAndDropHandler.this.mWrapper.smoothScrollBy(-scrollPx, 0);
            } else if (hoverViewTop + hoverHeight >= height && offset + extent < range) {
                DragAndDropHandler.this.mWrapper.smoothScrollBy(scrollPx, 0);
            }
        }

        public void onScroll(@NonNull AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            this.mCurrentFirstVisibleItem = firstVisibleItem;
            this.mCurrentLastVisibleItem = firstVisibleItem + visibleItemCount;
            this.mPreviousFirstVisibleItem = this.mPreviousFirstVisibleItem == -1 ? this.mCurrentFirstVisibleItem : this.mPreviousFirstVisibleItem;
            int n = this.mPreviousLastVisibleItem = this.mPreviousLastVisibleItem == -1 ? this.mCurrentLastVisibleItem : this.mPreviousLastVisibleItem;
            if (DragAndDropHandler.this.mHoverDrawable != null) {
                assert (DragAndDropHandler.this.mMobileView != null);
                float y = DragAndDropHandler.this.mMobileView.getY();
                DragAndDropHandler.this.mHoverDrawable.onScroll(y);
            }
            if (!DragAndDropHandler.this.mIsSettlingHoverDrawable) {
                this.checkAndHandleFirstVisibleCellChange();
                this.checkAndHandleLastVisibleCellChange();
            }
            this.mPreviousFirstVisibleItem = this.mCurrentFirstVisibleItem;
            this.mPreviousLastVisibleItem = this.mCurrentLastVisibleItem;
        }

        public void onScrollStateChanged(@NonNull AbsListView view, int scrollState) {
            if (scrollState == 0 && DragAndDropHandler.this.mHoverDrawable != null) {
                this.handleMobileCellScroll();
            }
        }

        private void checkAndHandleFirstVisibleCellChange() {
            if (DragAndDropHandler.this.mHoverDrawable == null || DragAndDropHandler.this.mAdapter == null || this.mCurrentFirstVisibleItem >= this.mPreviousFirstVisibleItem) {
                return;
            }
            int position = DragAndDropHandler.this.getPositionForId(DragAndDropHandler.this.mMobileItemId);
            if (position == -1) {
                return;
            }
            long switchItemId = position - 1 - DragAndDropHandler.this.mWrapper.getHeaderViewsCount() >= 0 ? DragAndDropHandler.this.mAdapter.getItemId(position - 1 - DragAndDropHandler.this.mWrapper.getHeaderViewsCount()) : -1L;
            View switchView = DragAndDropHandler.this.getViewForId(switchItemId);
            if (switchView != null) {
                DragAndDropHandler.this.switchViews(switchView, switchItemId, -switchView.getHeight());
            }
        }

        private void checkAndHandleLastVisibleCellChange() {
            if (DragAndDropHandler.this.mHoverDrawable == null || DragAndDropHandler.this.mAdapter == null || this.mCurrentLastVisibleItem <= this.mPreviousLastVisibleItem) {
                return;
            }
            int position = DragAndDropHandler.this.getPositionForId(DragAndDropHandler.this.mMobileItemId);
            if (position == -1) {
                return;
            }
            long switchItemId = position + 1 - DragAndDropHandler.this.mWrapper.getHeaderViewsCount() < DragAndDropHandler.this.mAdapter.getCount() ? DragAndDropHandler.this.mAdapter.getItemId(position + 1 - DragAndDropHandler.this.mWrapper.getHeaderViewsCount()) : -1L;
            View switchView = DragAndDropHandler.this.getViewForId(switchItemId);
            if (switchView != null) {
                DragAndDropHandler.this.switchViews(switchView, switchItemId, switchView.getHeight());
            }
        }
    }

    private class LSwitchViewAnimator
    implements SwitchViewAnimator {
        private LSwitchViewAnimator() {
        }

        @Override
        public void animateSwitchView(long switchId, float translationY) {
            DragAndDropHandler.this.mWrapper.getListView().getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)new AnimateSwitchViewOnPreDrawListener(switchId, translationY));
        }

        private class AnimateSwitchViewOnPreDrawListener
        implements ViewTreeObserver.OnPreDrawListener {
            private final long mSwitchId;
            private final float mTranslationY;

            AnimateSwitchViewOnPreDrawListener(long switchId, float translationY) {
                this.mSwitchId = switchId;
                this.mTranslationY = translationY;
            }

            public boolean onPreDraw() {
                DragAndDropHandler.this.mWrapper.getListView().getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                View switchView = DragAndDropHandler.this.getViewForId(this.mSwitchId);
                if (switchView != null) {
                    switchView.setTranslationY(this.mTranslationY);
                    switchView.animate().translationY(0.0f).start();
                }
                assert (DragAndDropHandler.this.mMobileView != null);
                DragAndDropHandler.this.mMobileView.setVisibility(0);
                DragAndDropHandler.this.mMobileView = DragAndDropHandler.this.getViewForId(DragAndDropHandler.this.mMobileItemId);
                assert (DragAndDropHandler.this.mMobileView != null);
                DragAndDropHandler.this.mMobileView.setVisibility(4);
                return true;
            }
        }
    }

    private class KitKatSwitchViewAnimator
    implements SwitchViewAnimator {
        private KitKatSwitchViewAnimator() {
        }

        @Override
        public void animateSwitchView(long switchId, float translationY) {
            assert (DragAndDropHandler.this.mMobileView != null);
            DragAndDropHandler.this.mWrapper.getListView().getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)new AnimateSwitchViewOnPreDrawListener(DragAndDropHandler.this.mMobileView, switchId, translationY));
            DragAndDropHandler.this.mMobileView = DragAndDropHandler.this.getViewForId(DragAndDropHandler.this.mMobileItemId);
        }

        private class AnimateSwitchViewOnPreDrawListener
        implements ViewTreeObserver.OnPreDrawListener {
            private final View mPreviousMobileView;
            private final long mSwitchId;
            private final float mTranslationY;

            AnimateSwitchViewOnPreDrawListener(View previousMobileView, long switchId, float translationY) {
                this.mPreviousMobileView = previousMobileView;
                this.mSwitchId = switchId;
                this.mTranslationY = translationY;
            }

            public boolean onPreDraw() {
                DragAndDropHandler.this.mWrapper.getListView().getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                View switchView = DragAndDropHandler.this.getViewForId(this.mSwitchId);
                if (switchView != null) {
                    switchView.setTranslationY(this.mTranslationY);
                    switchView.animate().translationY(0.0f).start();
                }
                this.mPreviousMobileView.setVisibility(0);
                if (DragAndDropHandler.this.mMobileView != null) {
                    DragAndDropHandler.this.mMobileView.setVisibility(4);
                }
                return true;
            }
        }
    }

    private static class DefaultDraggableManager
    implements DraggableManager {
        private DefaultDraggableManager() {
        }

        @Override
        public boolean isDraggable(@NonNull View view, int position, float x, float y) {
            return false;
        }
    }

    private static interface SwitchViewAnimator {
        public void animateSwitchView(long var1, float var3);
    }
}

