/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.dragdrop;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;

public class GripView
extends View {
    public static final int DEFAULT_DOT_COLOR = 0x1060000;
    public static final float DEFAULT_DOT_SIZE_RADIUS_DP = 2.0f;
    public static final int DEFAULT_COLUMN_COUNT = 2;
    private static final int[] ATTRS = new int[]{16843173};
    private final Paint mDotPaint = new Paint(1);
    private float mDotSizeRadiusPx;
    private float mPaddingTop;
    private int mColumnCount = 2;
    private int mRowCount;

    public GripView(@NonNull Context context) {
        this(context, null);
    }

    public GripView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GripView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int color = this.getResources().getColor(0x1060000);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, ATTRS);
            color = a.getColor(0, color);
            a.recycle();
        }
        this.mDotPaint.setColor(color);
        Resources r = context.getResources();
        this.mDotSizeRadiusPx = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)r.getDisplayMetrics());
    }

    public void setColor(int colorResId) {
        this.mDotPaint.setColor(this.getResources().getColor(colorResId));
    }

    public void setDotSizeRadiusPx(float dotSizeRadiusPx) {
        this.mDotSizeRadiusPx = dotSizeRadiusPx;
    }

    public void setColumnCount(int columnCount) {
        this.mColumnCount = columnCount;
        this.requestLayout();
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.mRowCount = (int)((float)(height - this.getPaddingTop() - this.getPaddingBottom()) / (this.mDotSizeRadiusPx * 4.0f));
        this.mPaddingTop = ((float)height - (float)this.mRowCount * this.mDotSizeRadiusPx * 2.0f - (float)(this.mRowCount - 1) * this.mDotSizeRadiusPx * 2.0f) / 2.0f;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.makeMeasureSpec((int)(this.getPaddingLeft() + this.getPaddingRight() + (int)((float)this.mColumnCount * (this.mDotSizeRadiusPx * 4.0f - 2.0f))), (int)0x40000000);
        super.onMeasure(width, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < this.mColumnCount; ++i) {
            float x = (float)this.getPaddingLeft() + (float)(i * 2) * this.mDotSizeRadiusPx * 2.0f;
            for (int j = 0; j < this.mRowCount; ++j) {
                float y = this.mPaddingTop + (float)(j * 2) * this.mDotSizeRadiusPx * 2.0f;
                canvas.drawCircle(x + this.mDotSizeRadiusPx, y + this.mDotSizeRadiusPx, this.mDotSizeRadiusPx, this.mDotPaint);
            }
        }
    }
}

