/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.dragdrop;

import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;
import com.nhaarman.listviewanimations.itemmanipulation.dragdrop.BitmapUtils;

class HoverDrawable
extends BitmapDrawable {
    private float mOriginalY;
    private float mDownY;
    private float mScrollDistance;

    HoverDrawable(@NonNull View view, @NonNull MotionEvent ev) {
        this(view, ev.getY());
    }

    HoverDrawable(@NonNull View view, float downY) {
        super(view.getResources(), BitmapUtils.getBitmapFromView(view));
        this.mOriginalY = view.getTop();
        this.mDownY = downY;
        this.setBounds(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
    }

    void handleMoveEvent(@NonNull MotionEvent ev) {
        int top = (int)(this.mOriginalY - this.mDownY + ev.getY() + this.mScrollDistance);
        this.setTop(top);
    }

    void onScroll(float mobileViewTopY) {
        this.mScrollDistance += this.mOriginalY - mobileViewTopY;
        this.mOriginalY = mobileViewTopY;
    }

    boolean isMovingUpwards() {
        return this.mOriginalY > (float)this.getBounds().top;
    }

    int getDeltaY() {
        return (int)((float)this.getBounds().top - this.mOriginalY);
    }

    int getTop() {
        return this.getBounds().top;
    }

    void setTop(int top) {
        this.setBounds(this.getBounds().left, top, this.getBounds().left + this.getIntrinsicWidth(), top + this.getIntrinsicHeight());
    }

    void shift(int height) {
        int shiftSize = this.isMovingUpwards() ? -height : height;
        this.mOriginalY += (float)shiftSize;
        this.mDownY += (float)shiftSize;
    }
}

