/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.expandablelistitem;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.nhaarman.listviewanimations.ArrayAdapter;
import com.nhaarman.listviewanimations.util.AdapterViewUtil;
import com.nhaarman.listviewanimations.util.ListViewWrapper;
import com.nhaarman.listviewanimations.util.ListViewWrapperSetter;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class ExpandableListItemAdapter<T>
extends ArrayAdapter<T>
implements ListViewWrapperSetter {
    private static final int DEFAULTTITLEPARENTRESID = 10000;
    private static final int DEFAULTCONTENTPARENTRESID = 10001;
    @NonNull
    private final Context mContext;
    private final int mTitleParentResId;
    private final int mContentParentResId;
    @NonNull
    private final List<Long> mExpandedIds;
    private int mViewLayoutResId;
    private int mActionViewResId;
    private int mLimit;
    @Nullable
    private ListViewWrapper mListViewWrapper;
    @Nullable
    private ExpandCollapseListener mExpandCollapseListener;

    protected ExpandableListItemAdapter(@NonNull Context context) {
        this(context, null);
    }

    protected ExpandableListItemAdapter(@NonNull Context context, @Nullable List<T> items) {
        super(items);
        this.mContext = context;
        this.mTitleParentResId = 10000;
        this.mContentParentResId = 10001;
        this.mExpandedIds = new ArrayList<Long>();
    }

    protected ExpandableListItemAdapter(@NonNull Context context, int layoutResId, int titleParentResId, int contentParentResId) {
        this(context, layoutResId, titleParentResId, contentParentResId, null);
    }

    protected ExpandableListItemAdapter(@NonNull Context context, int layoutResId, int titleParentResId, int contentParentResId, @Nullable List<T> items) {
        super(items);
        this.mContext = context;
        this.mViewLayoutResId = layoutResId;
        this.mTitleParentResId = titleParentResId;
        this.mContentParentResId = contentParentResId;
        this.mExpandedIds = new ArrayList<Long>();
    }

    public void setListViewWrapper(@NonNull ListViewWrapper listViewWrapper) {
        this.mListViewWrapper = listViewWrapper;
    }

    public void setActionViewResId(int resId) {
        this.mActionViewResId = resId;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
        this.mExpandedIds.clear();
        this.notifyDataSetChanged();
    }

    public void setExpandCollapseListener(@Nullable ExpandCollapseListener expandCollapseListener) {
        this.mExpandCollapseListener = expandCollapseListener;
    }

    @NonNull
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        ViewHolder viewHolder;
        ViewGroup view = (ViewGroup)convertView;
        if (view == null) {
            view = this.createView(parent);
            viewHolder = new ViewHolder();
            viewHolder.titleParent = (ViewGroup)view.findViewById(this.mTitleParentResId);
            viewHolder.contentParent = (ViewGroup)view.findViewById(this.mContentParentResId);
            view.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)view.getTag();
        }
        View titleView = this.getTitleView(position, viewHolder.titleView, viewHolder.titleParent);
        if (!titleView.equals(viewHolder.titleView)) {
            viewHolder.titleParent.removeAllViews();
            viewHolder.titleParent.addView(titleView);
            if (this.mActionViewResId == 0) {
                view.setOnClickListener((View.OnClickListener)new TitleViewOnClickListener((View)viewHolder.contentParent));
            } else {
                view.findViewById(this.mActionViewResId).setOnClickListener((View.OnClickListener)new TitleViewOnClickListener((View)viewHolder.contentParent));
            }
        }
        viewHolder.titleView = titleView;
        View contentView = this.getContentView(position, viewHolder.contentView, viewHolder.contentParent);
        if (!contentView.equals(viewHolder.contentView)) {
            viewHolder.contentParent.removeAllViews();
            viewHolder.contentParent.addView(contentView);
        }
        viewHolder.contentView = contentView;
        viewHolder.contentParent.setVisibility(this.mExpandedIds.contains(this.getItemId(position)) ? 0 : 8);
        viewHolder.contentParent.setTag((Object)this.getItemId(position));
        ViewGroup.LayoutParams layoutParams = viewHolder.contentParent.getLayoutParams();
        layoutParams.height = -2;
        viewHolder.contentParent.setLayoutParams(layoutParams);
        return view;
    }

    @NonNull
    public abstract View getTitleView(int var1, @Nullable View var2, @NonNull ViewGroup var3);

    @NonNull
    public abstract View getContentView(int var1, @Nullable View var2, @NonNull ViewGroup var3);

    public boolean isExpanded(int position) {
        long itemId = this.getItemId(position);
        return this.mExpandedIds.contains(itemId);
    }

    @Nullable
    public View getTitleView(int position) {
        Object tag;
        View titleView = null;
        View parentView = this.findViewForPosition(position);
        if (parentView != null && (tag = parentView.getTag()) instanceof ViewHolder) {
            titleView = ((ViewHolder)tag).titleView;
        }
        return titleView;
    }

    @Nullable
    public View getContentView(int position) {
        Object tag;
        View contentView = null;
        View parentView = this.findViewForPosition(position);
        if (parentView != null && (tag = parentView.getTag()) instanceof ViewHolder) {
            contentView = ((ViewHolder)tag).contentView;
        }
        return contentView;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        HashSet<Long> removedIds = new HashSet<Long>(this.mExpandedIds);
        for (int i = 0; i < this.getCount(); ++i) {
            long id = this.getItemId(i);
            removedIds.remove(id);
        }
        this.mExpandedIds.removeAll(removedIds);
    }

    public void expand(int position) {
        long itemId = this.getItemId(position);
        if (this.mExpandedIds.contains(itemId)) {
            return;
        }
        this.toggle(position);
    }

    public void collapse(int position) {
        long itemId = this.getItemId(position);
        if (!this.mExpandedIds.contains(itemId)) {
            return;
        }
        this.toggle(position);
    }

    public void toggle(int position) {
        long itemId = this.getItemId(position);
        boolean isExpanded = this.mExpandedIds.contains(itemId);
        View contentParent = this.getContentParent(position);
        if (contentParent != null) {
            this.toggle(contentParent);
        }
        if (contentParent == null && isExpanded) {
            this.mExpandedIds.remove(itemId);
        } else if (contentParent == null) {
            this.mExpandedIds.add(itemId);
        }
    }

    @NonNull
    private ViewGroup createView(@NonNull ViewGroup parent) {
        RootView view = this.mViewLayoutResId == 0 ? new RootView(this.mContext) : (ViewGroup)LayoutInflater.from((Context)this.mContext).inflate(this.mViewLayoutResId, parent, false);
        return view;
    }

    @Nullable
    private View getContentParent(int position) {
        Object tag;
        ViewGroup contentParent = null;
        View parentView = this.findViewForPosition(position);
        if (parentView != null && (tag = parentView.getTag()) instanceof ViewHolder) {
            contentParent = ((ViewHolder)tag).contentParent;
        }
        return contentParent;
    }

    @Nullable
    private View findViewForPosition(int position) {
        if (this.mListViewWrapper == null) {
            throw new IllegalStateException("Call setAbsListView on this ExpanableListItemAdapter!");
        }
        View result = null;
        for (int i = 0; i < this.mListViewWrapper.getChildCount() && result == null; ++i) {
            View childView = this.mListViewWrapper.getChildAt(i);
            if (childView == null || AdapterViewUtil.getPositionForView((ListViewWrapper)this.mListViewWrapper, (View)childView) != position) continue;
            result = childView;
        }
        return result;
    }

    private int findPositionForId(long id) {
        for (int i = 0; i < this.getCount(); ++i) {
            if (this.getItemId(i) != id) continue;
            return i;
        }
        return -1;
    }

    private void toggle(@NonNull View contentParent) {
        boolean shouldCollapseOther;
        if (this.mListViewWrapper == null) {
            throw new IllegalStateException("No ListView set!");
        }
        boolean isVisible = contentParent.getVisibility() == 0;
        boolean bl = shouldCollapseOther = !isVisible && this.mLimit > 0 && this.mExpandedIds.size() >= this.mLimit;
        if (shouldCollapseOther) {
            Long firstId = this.mExpandedIds.get(0);
            int firstPosition = this.findPositionForId(firstId);
            View firstEV = this.getContentParent(firstPosition);
            if (firstEV != null) {
                ExpandCollapseHelper.animateCollapsing(firstEV);
            }
            this.mExpandedIds.remove(firstId);
            if (this.mExpandCollapseListener != null) {
                this.mExpandCollapseListener.onItemCollapsed(firstPosition);
            }
        }
        Long id = (Long)contentParent.getTag();
        int position = this.findPositionForId(id);
        if (isVisible) {
            ExpandCollapseHelper.animateCollapsing(contentParent);
            this.mExpandedIds.remove(id);
            if (this.mExpandCollapseListener != null) {
                this.mExpandCollapseListener.onItemCollapsed(position);
            }
        } else {
            ExpandCollapseHelper.animateExpanding(contentParent, this.mListViewWrapper);
            this.mExpandedIds.add(id);
            if (this.mExpandCollapseListener != null) {
                this.mExpandCollapseListener.onItemExpanded(position);
            }
        }
    }

    private class TitleViewOnClickListener
    implements View.OnClickListener {
        private final View mContentParent;

        private TitleViewOnClickListener(View contentParent) {
            this.mContentParent = contentParent;
        }

        public void onClick(View view) {
            ExpandableListItemAdapter.this.toggle(this.mContentParent);
        }
    }

    private static class ExpandCollapseHelper {
        private ExpandCollapseHelper() {
        }

        public static void animateCollapsing(final View view) {
            int origHeight = view.getHeight();
            ValueAnimator animator = ExpandCollapseHelper.createHeightAnimator(view, origHeight, 0);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    view.setVisibility(8);
                }
            });
            animator.start();
        }

        public static void animateExpanding(final @NonNull View view, final @NonNull ListViewWrapper listViewWrapper) {
            view.setVisibility(0);
            View parent = (View)view.getParent();
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)(parent.getMeasuredWidth() - parent.getPaddingLeft() - parent.getPaddingRight()), (int)Integer.MIN_VALUE);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            view.measure(widthSpec, heightSpec);
            ValueAnimator animator = ExpandCollapseHelper.createHeightAnimator(view, 0, view.getMeasuredHeight());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                final int listViewHeight;
                final int listViewBottomPadding;
                final View v;
                {
                    this.listViewHeight = listViewWrapper.getListView().getHeight();
                    this.listViewBottomPadding = listViewWrapper.getListView().getPaddingBottom();
                    this.v = ExpandCollapseHelper.findDirectChild(view, listViewWrapper.getListView());
                }

                public void onAnimationUpdate(ValueAnimator animation) {
                    int top;
                    int bottom = this.v.getBottom();
                    if (bottom > this.listViewHeight && (top = this.v.getTop()) > 0) {
                        listViewWrapper.smoothScrollBy(Math.min(bottom - this.listViewHeight + this.listViewBottomPadding, top), 0);
                    }
                }
            });
            animator.start();
        }

        public static ValueAnimator createHeightAnimator(final View view, int start, int end) {
            ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{start, end});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                    layoutParams.height = value;
                    view.setLayoutParams(layoutParams);
                }
            });
            return animator;
        }

        @NonNull
        private static View findDirectChild(@NonNull View view, @NonNull ViewGroup listView) {
            View result = view;
            View parent = (View)result.getParent();
            while (!parent.equals(listView)) {
                result = parent;
                parent = (View)result.getParent();
            }
            return result;
        }
    }

    private static class ViewHolder {
        ViewGroup titleParent;
        ViewGroup contentParent;
        View titleView;
        View contentView;

        private ViewHolder() {
        }
    }

    private static class RootView
    extends LinearLayout {
        private ViewGroup mTitleViewGroup;
        private ViewGroup mContentViewGroup;

        private RootView(@NonNull Context context) {
            super(context);
            this.init();
        }

        private void init() {
            this.setOrientation(1);
            this.mTitleViewGroup = new FrameLayout(this.getContext());
            this.mTitleViewGroup.setId(10000);
            this.addView((View)this.mTitleViewGroup);
            this.mContentViewGroup = new FrameLayout(this.getContext());
            this.mContentViewGroup.setId(10001);
            this.addView((View)this.mContentViewGroup);
        }
    }

    public static interface ExpandCollapseListener {
        public void onItemExpanded(int var1);

        public void onItemCollapsed(int var1);
    }
}

