/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.BaseAdapter;
import com.nhaarman.listviewanimations.ArrayAdapter;
import com.nhaarman.listviewanimations.BaseAdapterDecorator;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.DismissableManager;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.OnDismissCallback;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.SwipeDismissTouchListener;
import com.nhaarman.listviewanimations.util.ListViewWrapper;

public class SwipeDismissAdapter
extends BaseAdapterDecorator {
    @NonNull
    private final OnDismissCallback mOnDismissCallback;
    @Nullable
    private SwipeDismissTouchListener mDismissTouchListener;
    private boolean mParentIsHorizontalScrollContainer;
    private int mSwipeTouchChildResId;

    public SwipeDismissAdapter(@NonNull BaseAdapter baseAdapter, @NonNull OnDismissCallback onDismissCallback) {
        super(baseAdapter);
        this.mOnDismissCallback = onDismissCallback;
    }

    public void setListViewWrapper(@NonNull ListViewWrapper listViewWrapper) {
        super.setListViewWrapper(listViewWrapper);
        if (this.getDecoratedBaseAdapter() instanceof ArrayAdapter) {
            ((ArrayAdapter)this.getDecoratedBaseAdapter()).propagateNotifyDataSetChanged((BaseAdapter)this);
        }
        this.mDismissTouchListener = new SwipeDismissTouchListener(listViewWrapper, this.mOnDismissCallback);
        if (this.mParentIsHorizontalScrollContainer) {
            this.mDismissTouchListener.setParentIsHorizontalScrollContainer();
        }
        if (this.mSwipeTouchChildResId != 0) {
            this.mDismissTouchListener.setTouchChild(this.mSwipeTouchChildResId);
        }
        listViewWrapper.getListView().setOnTouchListener((View.OnTouchListener)this.mDismissTouchListener);
    }

    public void setDismissableManager(@Nullable DismissableManager dismissableManager) {
        if (this.mDismissTouchListener == null) {
            throw new IllegalStateException("You must call setAbsListView() first.");
        }
        this.mDismissTouchListener.setDismissableManager(dismissableManager);
    }

    public void setParentIsHorizontalScrollContainer() {
        this.mParentIsHorizontalScrollContainer = true;
        this.mSwipeTouchChildResId = 0;
        if (this.mDismissTouchListener != null) {
            this.mDismissTouchListener.setParentIsHorizontalScrollContainer();
        }
    }

    public void setSwipeTouchChildResId(int childResId) {
        this.mSwipeTouchChildResId = childResId;
        if (this.mDismissTouchListener != null) {
            this.mDismissTouchListener.setTouchChild(childResId);
        }
    }

    public void dismiss(int position) {
        if (this.mDismissTouchListener == null) {
            throw new IllegalStateException("Call setListViewWrapper on this SwipeDismissAdapter!");
        }
        this.mDismissTouchListener.dismiss(position);
    }

    @Nullable
    public SwipeDismissTouchListener getDismissTouchListener() {
        return this.mDismissTouchListener;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        if (this.mDismissTouchListener != null) {
            this.mDismissTouchListener.notifyDataSetChanged();
        }
    }
}

