/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss;

import android.os.Handler;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.OnDismissCallback;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.SwipeTouchListener;
import com.nhaarman.listviewanimations.util.AdapterViewUtil;
import com.nhaarman.listviewanimations.util.ListViewWrapper;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ValueAnimator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SwipeDismissTouchListener
extends SwipeTouchListener {
    @NonNull
    private final OnDismissCallback mCallback;
    private final long mDismissAnimationTime;
    @NonNull
    private final Collection<View> mDismissedViews = new LinkedList<View>();
    @NonNull
    private final List<Integer> mDismissedPositions = new LinkedList<Integer>();
    private int mActiveDismissCount;
    @NonNull
    private final Handler mHandler = new Handler();

    public SwipeDismissTouchListener(@NonNull ListViewWrapper listViewWrapper, @NonNull OnDismissCallback callback) {
        super(listViewWrapper);
        this.mCallback = callback;
        this.mDismissAnimationTime = listViewWrapper.getListView().getContext().getResources().getInteger(0x10E0000);
    }

    public void dismiss(int position) {
        this.fling(position);
    }

    @Override
    public void fling(int position) {
        int firstVisiblePosition = this.getListViewWrapper().getFirstVisiblePosition();
        int lastVisiblePosition = this.getListViewWrapper().getLastVisiblePosition();
        if (firstVisiblePosition <= position && position <= lastVisiblePosition) {
            super.fling(position);
        } else if (position > lastVisiblePosition) {
            this.directDismiss(position);
        } else {
            this.dismissAbove(position);
        }
    }

    protected void directDismiss(int position) {
        this.mDismissedPositions.add(position);
        this.finalizeDismiss();
    }

    private void dismissAbove(int position) {
        View view = AdapterViewUtil.getViewForPosition((ListViewWrapper)this.getListViewWrapper(), (int)this.getListViewWrapper().getFirstVisiblePosition());
        if (view != null) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            int scrollDistance = view.getMeasuredHeight();
            this.getListViewWrapper().smoothScrollBy(scrollDistance, (int)this.mDismissAnimationTime);
            this.mHandler.postDelayed((Runnable)new RestoreScrollRunnable(scrollDistance, position), this.mDismissAnimationTime);
        }
    }

    @Override
    protected void afterCancelSwipe(@NonNull View view, int position) {
        this.finalizeDismiss();
    }

    @Override
    protected boolean willLeaveDataSetOnFling(@NonNull View view, int position) {
        return true;
    }

    @Override
    protected void afterViewFling(@NonNull View view, int position) {
        this.performDismiss(view, position);
    }

    protected void performDismiss(@NonNull View view, int position) {
        this.mDismissedViews.add(view);
        this.mDismissedPositions.add(position);
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{view.getHeight(), 1}).setDuration(this.mDismissAnimationTime);
        animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new DismissAnimatorUpdateListener(view));
        animator.addListener((Animator.AnimatorListener)new DismissAnimatorListener());
        animator.start();
        ++this.mActiveDismissCount;
    }

    protected void finalizeDismiss() {
        if (this.mActiveDismissCount == 0 && this.getActiveSwipeCount() == 0) {
            this.restoreViewPresentations(this.mDismissedViews);
            this.notifyCallback(this.mDismissedPositions);
            this.mDismissedViews.clear();
            this.mDismissedPositions.clear();
        }
    }

    protected void notifyCallback(@NonNull List<Integer> dismissedPositions) {
        if (!dismissedPositions.isEmpty()) {
            Collections.sort(dismissedPositions, Collections.reverseOrder());
            int[] dismissPositions = new int[dismissedPositions.size()];
            int i = 0;
            for (Integer dismissedPosition : dismissedPositions) {
                dismissPositions[i] = dismissedPosition;
                ++i;
            }
            this.mCallback.onDismiss(this.getListViewWrapper().getListView(), dismissPositions);
        }
    }

    protected void restoreViewPresentations(@NonNull Iterable<View> views) {
        for (View view : views) {
            this.restoreViewPresentation(view);
        }
    }

    @Override
    protected void restoreViewPresentation(@NonNull View view) {
        super.restoreViewPresentation(view);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.height = 0;
        view.setLayoutParams(layoutParams);
    }

    protected int getActiveDismissCount() {
        return this.mActiveDismissCount;
    }

    public long getDismissAnimationTime() {
        return this.mDismissAnimationTime;
    }

    private class RestoreScrollRunnable
    implements Runnable {
        private final int mScrollDistance;
        private final int mPosition;

        RestoreScrollRunnable(int scrollDistance, int position) {
            this.mScrollDistance = scrollDistance;
            this.mPosition = position;
        }

        @Override
        public void run() {
            SwipeDismissTouchListener.this.getListViewWrapper().smoothScrollBy(-this.mScrollDistance, 1);
            SwipeDismissTouchListener.this.directDismiss(this.mPosition);
        }
    }

    private class DismissAnimatorListener
    extends AnimatorListenerAdapter {
        private DismissAnimatorListener() {
        }

        public void onAnimationEnd(@NonNull Animator animation) {
            SwipeDismissTouchListener.this.mActiveDismissCount--;
            SwipeDismissTouchListener.this.finalizeDismiss();
        }
    }

    private static class DismissAnimatorUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        @NonNull
        private final View mView;

        DismissAnimatorUpdateListener(@NonNull View view) {
            this.mView = view;
        }

        public void onAnimationUpdate(@NonNull ValueAnimator animation) {
            ViewGroup.LayoutParams layoutParams = this.mView.getLayoutParams();
            layoutParams.height = (Integer)animation.getAnimatedValue();
            this.mView.setLayoutParams(layoutParams);
        }
    }
}

