/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.nhaarman.listviewanimations.itemmanipulation.TouchEventHandler;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.DismissableManager;
import com.nhaarman.listviewanimations.util.AdapterViewUtil;
import com.nhaarman.listviewanimations.util.ListViewWrapper;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;

public abstract class SwipeTouchListener
implements View.OnTouchListener,
TouchEventHandler {
    private static final String TRANSLATION_X = "translationX";
    private static final String ALPHA = "alpha";
    private static final int MIN_FLING_VELOCITY_FACTOR = 16;
    private final int mSlop;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    private final long mAnimationTime;
    @NonNull
    private final ListViewWrapper mListViewWrapper;
    private float mMinimumAlpha;
    private int mViewWidth = 1;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private boolean mCanDismissCurrent;
    @Nullable
    private VelocityTracker mVelocityTracker;
    @Nullable
    private View mCurrentView;
    @Nullable
    private View mSwipingView;
    private int mCurrentPosition = -1;
    private int mVirtualListCount = -1;
    private boolean mParentIsHorizontalScrollContainer;
    private int mTouchChildResId;
    @Nullable
    private DismissableManager mDismissableManager;
    private int mActiveSwipeCount;
    private boolean mSwipeEnabled = true;

    protected SwipeTouchListener(@NonNull ListViewWrapper listViewWrapper) {
        ViewConfiguration vc = ViewConfiguration.get((Context)listViewWrapper.getListView().getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity() * 16;
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = listViewWrapper.getListView().getContext().getResources().getInteger(0x10E0000);
        this.mListViewWrapper = listViewWrapper;
    }

    public void setDismissableManager(@Nullable DismissableManager dismissableManager) {
        this.mDismissableManager = dismissableManager;
    }

    public void setMinimumAlpha(float minimumAlpha) {
        this.mMinimumAlpha = minimumAlpha;
    }

    public void setParentIsHorizontalScrollContainer() {
        this.mParentIsHorizontalScrollContainer = true;
        this.mTouchChildResId = 0;
    }

    public void setTouchChild(int childResId) {
        this.mTouchChildResId = childResId;
        this.mParentIsHorizontalScrollContainer = false;
    }

    public void notifyDataSetChanged() {
        if (this.mListViewWrapper.getAdapter() != null) {
            this.mVirtualListCount = this.mListViewWrapper.getCount() - this.mListViewWrapper.getHeaderViewsCount();
        }
    }

    public boolean isSwiping() {
        return this.mSwiping;
    }

    @NonNull
    public ListViewWrapper getListViewWrapper() {
        return this.mListViewWrapper;
    }

    public void enableSwipe() {
        this.mSwipeEnabled = true;
    }

    public void disableSwipe() {
        this.mSwipeEnabled = false;
    }

    public void fling(int position) {
        int firstVisiblePosition = this.mListViewWrapper.getFirstVisiblePosition();
        int lastVisiblePosition = this.mListViewWrapper.getLastVisiblePosition();
        if (position < firstVisiblePosition || position > lastVisiblePosition) {
            throw new IllegalArgumentException("View for position " + position + " not visible!");
        }
        View downView = AdapterViewUtil.getViewForPosition((ListViewWrapper)this.mListViewWrapper, (int)position);
        if (downView == null) {
            throw new IllegalStateException("No view found for position " + position);
        }
        this.flingView(downView, position, true);
        ++this.mActiveSwipeCount;
        --this.mVirtualListCount;
    }

    @Override
    public boolean isInteracting() {
        return this.mSwiping;
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        return this.onTouch(null, event);
    }

    public boolean onTouch(@Nullable View view, @NonNull MotionEvent event) {
        boolean result;
        if (this.mListViewWrapper.getAdapter() == null) {
            return false;
        }
        if (this.mVirtualListCount == -1 || this.mActiveSwipeCount == 0) {
            this.mVirtualListCount = this.mListViewWrapper.getCount() - this.mListViewWrapper.getHeaderViewsCount();
        }
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mListViewWrapper.getListView().getWidth();
        }
        switch (event.getActionMasked()) {
            case 0: {
                result = this.handleDownEvent(view, event);
                break;
            }
            case 2: {
                result = this.handleMoveEvent(view, event);
                break;
            }
            case 3: {
                result = this.handleCancelEvent();
                break;
            }
            case 1: {
                result = this.handleUpEvent(event);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private boolean handleDownEvent(@Nullable View view, @NonNull MotionEvent motionEvent) {
        if (!this.mSwipeEnabled) {
            return false;
        }
        View downView = this.findDownView(motionEvent);
        if (downView == null) {
            return false;
        }
        int downPosition = AdapterViewUtil.getPositionForView((ListViewWrapper)this.mListViewWrapper, (View)downView);
        this.mCanDismissCurrent = this.isDismissable(downPosition);
        if (this.mCurrentPosition == downPosition || downPosition >= this.mVirtualListCount) {
            return false;
        }
        if (view != null) {
            view.onTouchEvent(motionEvent);
        }
        this.disableHorizontalScrollContainerIfNecessary(motionEvent, downView);
        this.mDownX = motionEvent.getX();
        this.mDownY = motionEvent.getY();
        this.mCurrentView = downView;
        this.mSwipingView = this.getSwipeView(downView);
        this.mCurrentPosition = downPosition;
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mVelocityTracker.addMovement(motionEvent);
        return true;
    }

    @Nullable
    private View findDownView(@NonNull MotionEvent motionEvent) {
        Rect rect = new Rect();
        int childCount = this.mListViewWrapper.getChildCount();
        int x = (int)motionEvent.getX();
        int y = (int)motionEvent.getY();
        View downView = null;
        for (int i = 0; i < childCount && downView == null; ++i) {
            View child = this.mListViewWrapper.getChildAt(i);
            if (child == null) continue;
            child.getHitRect(rect);
            if (!rect.contains(x, y)) continue;
            downView = child;
        }
        return downView;
    }

    private boolean isDismissable(int position) {
        if (this.mListViewWrapper.getAdapter() == null) {
            return false;
        }
        if (this.mDismissableManager != null) {
            long downId = this.mListViewWrapper.getAdapter().getItemId(position);
            return this.mDismissableManager.isDismissable(downId, position);
        }
        return true;
    }

    private void disableHorizontalScrollContainerIfNecessary(@NonNull MotionEvent motionEvent, @NonNull View view) {
        if (this.mParentIsHorizontalScrollContainer) {
            this.mListViewWrapper.getListView().requestDisallowInterceptTouchEvent(true);
        } else if (this.mTouchChildResId != 0) {
            Rect childRect;
            this.mParentIsHorizontalScrollContainer = false;
            View childView = view.findViewById(this.mTouchChildResId);
            if (childView != null && (childRect = SwipeTouchListener.getChildViewRect((View)this.mListViewWrapper.getListView(), childView)).contains((int)motionEvent.getX(), (int)motionEvent.getY())) {
                this.mListViewWrapper.getListView().requestDisallowInterceptTouchEvent(true);
            }
        }
    }

    private boolean handleMoveEvent(@Nullable View view, @NonNull MotionEvent motionEvent) {
        if (this.mVelocityTracker == null || this.mCurrentView == null) {
            return false;
        }
        this.mVelocityTracker.addMovement(motionEvent);
        float deltaX = motionEvent.getX() - this.mDownX;
        float deltaY = motionEvent.getY() - this.mDownY;
        if (Math.abs(deltaX) > (float)this.mSlop && Math.abs(deltaX) > Math.abs(deltaY)) {
            if (!this.mSwiping) {
                ++this.mActiveSwipeCount;
                this.onStartSwipe(this.mCurrentView, this.mCurrentPosition);
            }
            this.mSwiping = true;
            this.mListViewWrapper.getListView().requestDisallowInterceptTouchEvent(true);
            if (view != null) {
                MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                cancelEvent.setAction(3 | motionEvent.getActionIndex() << 8);
                view.onTouchEvent(cancelEvent);
                cancelEvent.recycle();
            }
        }
        if (this.mSwiping) {
            if (this.mCanDismissCurrent) {
                ViewHelper.setTranslationX((View)this.mSwipingView, (float)deltaX);
                ViewHelper.setAlpha((View)this.mSwipingView, (float)Math.max(this.mMinimumAlpha, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaX) / (float)this.mViewWidth)));
            } else {
                ViewHelper.setTranslationX((View)this.mSwipingView, (float)(deltaX * 0.1f));
            }
            return true;
        }
        return false;
    }

    private boolean handleCancelEvent() {
        if (this.mVelocityTracker == null || this.mCurrentView == null) {
            return false;
        }
        if (this.mCurrentPosition != -1 && this.mSwiping) {
            this.onCancelSwipe(this.mCurrentView, this.mCurrentPosition);
            this.restoreCurrentViewTranslation();
        }
        this.reset();
        return false;
    }

    private boolean handleUpEvent(@NonNull MotionEvent motionEvent) {
        if (this.mVelocityTracker == null || this.mCurrentView == null) {
            return false;
        }
        if (this.mSwiping) {
            boolean shouldDismiss = false;
            boolean dismissToRight = false;
            if (this.mCanDismissCurrent) {
                float deltaX = motionEvent.getX() - this.mDownX;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float velocityX = Math.abs(this.mVelocityTracker.getXVelocity());
                float velocityY = Math.abs(this.mVelocityTracker.getYVelocity());
                if (Math.abs(deltaX) > (float)(this.mViewWidth / 2)) {
                    shouldDismiss = true;
                    dismissToRight = deltaX > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= velocityX && velocityX <= (float)this.mMaxFlingVelocity && velocityY < velocityX) {
                    shouldDismiss = true;
                    boolean bl = dismissToRight = this.mVelocityTracker.getXVelocity() > 0.0f;
                }
            }
            if (shouldDismiss) {
                this.beforeViewFling(this.mCurrentView, this.mCurrentPosition);
                if (this.willLeaveDataSetOnFling(this.mCurrentView, this.mCurrentPosition)) {
                    --this.mVirtualListCount;
                }
                this.flingCurrentView(dismissToRight);
            } else {
                this.onCancelSwipe(this.mCurrentView, this.mCurrentPosition);
                this.restoreCurrentViewTranslation();
            }
        }
        this.reset();
        return false;
    }

    private void flingCurrentView(boolean flingToRight) {
        if (this.mCurrentView != null) {
            this.flingView(this.mCurrentView, this.mCurrentPosition, flingToRight);
        }
    }

    private void flingView(@NonNull View view, int position, boolean flingToRight) {
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mListViewWrapper.getListView().getWidth();
        }
        View swipeView = this.getSwipeView(view);
        ObjectAnimator xAnimator = ObjectAnimator.ofFloat((Object)swipeView, (String)TRANSLATION_X, (float[])new float[]{flingToRight ? (float)this.mViewWidth : (float)(-this.mViewWidth)});
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)swipeView, (String)ALPHA, (float[])new float[]{0.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{xAnimator, alphaAnimator});
        animatorSet.setDuration(this.mAnimationTime);
        animatorSet.addListener((Animator.AnimatorListener)new FlingAnimatorListener(view, position));
        animatorSet.start();
    }

    private void restoreCurrentViewTranslation() {
        if (this.mCurrentView == null) {
            return;
        }
        ObjectAnimator xAnimator = ObjectAnimator.ofFloat((Object)this.mSwipingView, (String)TRANSLATION_X, (float[])new float[]{0.0f});
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)this.mSwipingView, (String)ALPHA, (float[])new float[]{1.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{xAnimator, alphaAnimator});
        animatorSet.setDuration(this.mAnimationTime);
        animatorSet.addListener((Animator.AnimatorListener)new RestoreAnimatorListener(this.mCurrentView, this.mCurrentPosition));
        animatorSet.start();
    }

    private void reset() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = null;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mCurrentView = null;
        this.mSwipingView = null;
        this.mCurrentPosition = -1;
        this.mSwiping = false;
        this.mCanDismissCurrent = false;
    }

    protected void onStartSwipe(@NonNull View view, int position) {
    }

    protected void onCancelSwipe(@NonNull View view, int position) {
    }

    protected void afterCancelSwipe(@NonNull View view, int position) {
    }

    protected void beforeViewFling(@NonNull View view, int position) {
    }

    protected abstract boolean willLeaveDataSetOnFling(@NonNull View var1, int var2);

    protected abstract void afterViewFling(@NonNull View var1, int var2);

    protected void restoreViewPresentation(@NonNull View view) {
        View swipedView = this.getSwipeView(view);
        ViewHelper.setAlpha((View)swipedView, (float)1.0f);
        ViewHelper.setTranslationX((View)swipedView, (float)0.0f);
    }

    protected int getActiveSwipeCount() {
        return this.mActiveSwipeCount;
    }

    @NonNull
    protected View getSwipeView(@NonNull View view) {
        return view;
    }

    private static Rect getChildViewRect(View parentView, View childView) {
        Rect childRect = new Rect(childView.getLeft(), childView.getTop(), childView.getRight(), childView.getBottom());
        if (!parentView.equals(childView)) {
            ViewGroup parent;
            View workingChildView = childView;
            while (!(parent = (ViewGroup)workingChildView.getParent()).equals(parentView)) {
                childRect.offset(parent.getLeft(), parent.getTop());
                workingChildView = parent;
            }
        }
        return childRect;
    }

    private class RestoreAnimatorListener
    extends AnimatorListenerAdapter {
        @NonNull
        private final View mView;
        private final int mPosition;

        private RestoreAnimatorListener(View view, int position) {
            this.mView = view;
            this.mPosition = position;
        }

        public void onAnimationEnd(@NonNull Animator animation) {
            SwipeTouchListener.this.mActiveSwipeCount--;
            SwipeTouchListener.this.afterCancelSwipe(this.mView, this.mPosition);
        }
    }

    private class FlingAnimatorListener
    extends AnimatorListenerAdapter {
        @NonNull
        private final View mView;
        private final int mPosition;

        private FlingAnimatorListener(View view, int position) {
            this.mView = view;
            this.mPosition = position;
        }

        public void onAnimationEnd(@NonNull Animator animation) {
            SwipeTouchListener.this.mActiveSwipeCount--;
            SwipeTouchListener.this.afterViewFling(this.mView, this.mPosition);
        }
    }
}

