/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.nhaarman.listviewanimations.BaseAdapterDecorator;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.OnDismissCallback;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.SwipeUndoAdapter;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.SwipeUndoView;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.UndoAdapter;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.UndoCallback;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.Util;
import java.util.ArrayList;
import java.util.Collection;

public class SimpleSwipeUndoAdapter
extends SwipeUndoAdapter
implements UndoCallback {
    @NonNull
    private final Context mContext;
    @NonNull
    private final OnDismissCallback mOnDismissCallback;
    @NonNull
    private final UndoAdapter mUndoAdapter;
    private final Collection<Integer> mUndoPositions = new ArrayList<Integer>();

    public SimpleSwipeUndoAdapter(@NonNull BaseAdapter adapter, @NonNull Context context, @NonNull OnDismissCallback dismissCallback) {
        super(adapter, null);
        this.setUndoCallback(this);
        BaseAdapter undoAdapter = adapter;
        while (undoAdapter instanceof BaseAdapterDecorator) {
            undoAdapter = ((BaseAdapterDecorator)undoAdapter).getDecoratedBaseAdapter();
        }
        if (!(undoAdapter instanceof UndoAdapter)) {
            throw new IllegalStateException("BaseAdapter must implement UndoAdapter!");
        }
        this.mUndoAdapter = (UndoAdapter)undoAdapter;
        this.mContext = context;
        this.mOnDismissCallback = dismissCallback;
    }

    @Override
    @NonNull
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        SwipeUndoView view = (SwipeUndoView)convertView;
        if (view == null) {
            view = new SwipeUndoView(this.mContext);
        }
        View primaryView = super.getView(position, view.getPrimaryView(), (ViewGroup)view);
        view.setPrimaryView(primaryView);
        View undoView = this.mUndoAdapter.getUndoView(position, view.getUndoView(), (ViewGroup)view);
        view.setUndoView(undoView);
        this.mUndoAdapter.getUndoClickView(undoView).setOnClickListener((View.OnClickListener)new UndoClickListener(view, position));
        boolean isInUndoState = this.mUndoPositions.contains(position);
        primaryView.setVisibility(isInUndoState ? 8 : 0);
        undoView.setVisibility(isInUndoState ? 0 : 8);
        return view;
    }

    @Override
    @NonNull
    public View getPrimaryView(@NonNull View view) {
        View primaryView = ((SwipeUndoView)view).getPrimaryView();
        if (primaryView == null) {
            throw new IllegalStateException("primaryView == null");
        }
        return primaryView;
    }

    @Override
    @NonNull
    public View getUndoView(@NonNull View view) {
        View undoView = ((SwipeUndoView)view).getUndoView();
        if (undoView == null) {
            throw new IllegalStateException("undoView == null");
        }
        return undoView;
    }

    @Override
    public void onUndoShown(@NonNull View view, int position) {
        this.mUndoPositions.add(position);
    }

    @Override
    public void onUndo(@NonNull View view, int position) {
        this.mUndoPositions.remove(position);
    }

    @Override
    public void onDismiss(@NonNull View view, int position) {
        this.mUndoPositions.remove(position);
    }

    @Override
    public void onDismiss(@NonNull ViewGroup listView, @NonNull int[] reverseSortedPositions) {
        this.mOnDismissCallback.onDismiss(listView, reverseSortedPositions);
        Collection<Integer> newUndoPositions = Util.processDeletions(this.mUndoPositions, reverseSortedPositions);
        this.mUndoPositions.clear();
        this.mUndoPositions.addAll(newUndoPositions);
    }

    private class UndoClickListener
    implements View.OnClickListener {
        @NonNull
        private final SwipeUndoView mView;
        private final int mPosition;

        UndoClickListener(SwipeUndoView view, int position) {
            this.mView = view;
            this.mPosition = position;
        }

        public void onClick(@NonNull View v) {
            SimpleSwipeUndoAdapter.this.undo((View)this.mView);
        }
    }
}

