/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.nhaarman.listviewanimations.BaseAdapterDecorator;
import com.nhaarman.listviewanimations.itemmanipulation.DynamicListView;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.DismissableManager;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.SwipeUndoTouchListener;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.UndoCallback;
import com.nhaarman.listviewanimations.util.ListViewWrapper;

public abstract class SwipeUndoAdapter
extends BaseAdapterDecorator {
    @Nullable
    private SwipeUndoTouchListener mSwipeUndoTouchListener;
    @NonNull
    private UndoCallback mUndoCallback;

    protected SwipeUndoAdapter(@NonNull BaseAdapter baseAdapter, @NonNull UndoCallback undoCallback) {
        super(baseAdapter);
        this.mUndoCallback = undoCallback;
    }

    public void setListViewWrapper(@NonNull ListViewWrapper listViewWrapper) {
        super.setListViewWrapper(listViewWrapper);
        this.mSwipeUndoTouchListener = new SwipeUndoTouchListener(listViewWrapper, this.mUndoCallback);
        if (!(listViewWrapper.getListView() instanceof DynamicListView)) {
            listViewWrapper.getListView().setOnTouchListener((View.OnTouchListener)this.mSwipeUndoTouchListener);
        }
    }

    public void setDismissableManager(@Nullable DismissableManager dismissableManager) {
        if (this.mSwipeUndoTouchListener == null) {
            throw new IllegalStateException("You must call setAbsListView() first.");
        }
        this.mSwipeUndoTouchListener.setDismissableManager(dismissableManager);
    }

    public void setSwipeUndoTouchListener(@NonNull SwipeUndoTouchListener swipeUndoTouchListener) {
        this.mSwipeUndoTouchListener = swipeUndoTouchListener;
    }

    @NonNull
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        if (this.getListViewWrapper() == null) {
            throw new IllegalArgumentException("Call setAbsListView() on this SwipeUndoAdapter before setAdapter()!");
        }
        return super.getView(position, convertView, parent);
    }

    public void setUndoCallback(@NonNull UndoCallback undoCallback) {
        this.mUndoCallback = undoCallback;
    }

    @NonNull
    public UndoCallback getUndoCallback() {
        return this.mUndoCallback;
    }

    public void undo(@NonNull View view) {
        this.mSwipeUndoTouchListener.undo(view);
    }

    public void dismiss(int position) {
        this.mSwipeUndoTouchListener.dismiss(position);
    }
}

