/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.SwipeDismissTouchListener;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.UndoCallback;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.Util;
import com.nhaarman.listviewanimations.util.AdapterViewUtil;
import com.nhaarman.listviewanimations.util.ListViewWrapper;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SwipeUndoTouchListener
extends SwipeDismissTouchListener {
    private static final String ALPHA = "alpha";
    private static final String TRANSLATION_X = "translationX";
    @NonNull
    private final UndoCallback mCallback;
    @NonNull
    private final Collection<Integer> mUndoPositions = new LinkedList<Integer>();
    @NonNull
    private final Map<Integer, View> mUndoViews = new HashMap<Integer, View>();
    @NonNull
    private final List<Integer> mDismissedPositions = new LinkedList<Integer>();
    @NonNull
    private final Collection<View> mDismissedViews = new LinkedList<View>();

    public SwipeUndoTouchListener(@NonNull ListViewWrapper listViewWrapper, @NonNull UndoCallback callback) {
        super(listViewWrapper, callback);
        this.mCallback = callback;
    }

    @Override
    protected boolean willLeaveDataSetOnFling(@NonNull View view, int position) {
        return this.mUndoPositions.contains(position);
    }

    @Override
    protected void afterViewFling(@NonNull View view, int position) {
        if (this.mUndoPositions.contains(position)) {
            this.mUndoPositions.remove(position);
            this.mUndoViews.remove(position);
            this.performDismiss(view, position);
            this.hideUndoView(view);
        } else {
            this.mUndoPositions.add(position);
            this.mUndoViews.put(position, view);
            this.mCallback.onUndoShown(view, position);
            this.showUndoView(view);
            this.restoreViewPresentation(view);
        }
    }

    @Override
    protected void afterCancelSwipe(@NonNull View view, int position) {
        this.finalizeDismiss();
    }

    @Override
    protected void performDismiss(@NonNull View view, int position) {
        super.performDismiss(view, position);
        this.mDismissedViews.add(view);
        this.mDismissedPositions.add(position);
        this.mCallback.onDismiss(view, position);
    }

    public boolean hasPendingItems() {
        return !this.mUndoPositions.isEmpty();
    }

    public void dimissPending() {
        for (int position : this.mUndoPositions) {
            this.performDismiss(this.mUndoViews.get(position), position);
        }
    }

    private void showUndoView(@NonNull View view) {
        this.mCallback.getPrimaryView(view).setVisibility(8);
        View undoView = this.mCallback.getUndoView(view);
        undoView.setVisibility(0);
        ObjectAnimator.ofFloat((Object)undoView, (String)ALPHA, (float[])new float[]{0.0f, 1.0f}).start();
    }

    private void hideUndoView(@NonNull View view) {
        this.mCallback.getPrimaryView(view).setVisibility(0);
        this.mCallback.getUndoView(view).setVisibility(8);
    }

    @Override
    protected void finalizeDismiss() {
        if (this.getActiveDismissCount() == 0 && this.getActiveSwipeCount() == 0) {
            this.restoreViewPresentations(this.mDismissedViews);
            this.notifyCallback(this.mDismissedPositions);
            Collection<Integer> newUndoPositions = Util.processDeletions(this.mUndoPositions, this.mDismissedPositions);
            this.mUndoPositions.clear();
            this.mUndoPositions.addAll(newUndoPositions);
            this.mDismissedViews.clear();
            this.mDismissedPositions.clear();
        }
    }

    @Override
    protected void restoreViewPresentation(@NonNull View view) {
        super.restoreViewPresentation(view);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.height = 0;
        view.setLayoutParams(layoutParams);
    }

    public void undo(@NonNull View view) {
        int position = AdapterViewUtil.getPositionForView((ListViewWrapper)this.getListViewWrapper(), (View)view);
        this.mUndoPositions.remove(position);
        View primaryView = this.mCallback.getPrimaryView(view);
        View undoView = this.mCallback.getUndoView(view);
        primaryView.setVisibility(0);
        ObjectAnimator undoAlphaAnimator = ObjectAnimator.ofFloat((Object)undoView, (String)ALPHA, (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator primaryAlphaAnimator = ObjectAnimator.ofFloat((Object)primaryView, (String)ALPHA, (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator primaryXAnimator = ObjectAnimator.ofFloat((Object)primaryView, (String)TRANSLATION_X, (float[])new float[]{primaryView.getWidth(), 0.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{undoAlphaAnimator, primaryAlphaAnimator, primaryXAnimator});
        animatorSet.addListener((Animator.AnimatorListener)new UndoAnimatorListener(undoView));
        animatorSet.start();
        this.mCallback.onUndo(view, position);
    }

    @Override
    protected void directDismiss(int position) {
        this.mDismissedPositions.add(position);
        this.finalizeDismiss();
    }

    private class UndoAnimatorListener
    extends AnimatorListenerAdapter {
        @NonNull
        private final View mUndoView;

        UndoAnimatorListener(View undoView) {
            this.mUndoView = undoView;
        }

        public void onAnimationEnd(@NonNull Animator animation) {
            this.mUndoView.setVisibility(8);
            SwipeUndoTouchListener.this.finalizeDismiss();
        }
    }
}

