/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.OnDismissCallback;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.undo.SimpleSwipeUndoAdapter;
import java.util.HashMap;
import java.util.Map;

public class TimedUndoAdapter
extends SimpleSwipeUndoAdapter {
    public static final long DEFAULT_TIMEOUT_MS = 3000L;
    private long mTimeoutMs = 3000L;
    @NonNull
    private final Handler mHandler = new Handler();
    private final Map<Integer, TimeoutRunnable> mRunnables = new HashMap<Integer, TimeoutRunnable>();

    public <V extends BaseAdapter> TimedUndoAdapter(@NonNull V undoAdapter, @NonNull Context context, @NonNull OnDismissCallback dismissCallback) {
        super(undoAdapter, context, dismissCallback);
    }

    public void setTimeoutMs(long timeoutMs) {
        this.mTimeoutMs = timeoutMs;
    }

    @Override
    public void onUndoShown(@NonNull View view, int position) {
        super.onUndoShown(view, position);
        TimeoutRunnable timeoutRunnable = new TimeoutRunnable(position);
        this.mRunnables.put(position, timeoutRunnable);
        this.mHandler.postDelayed((Runnable)timeoutRunnable, this.mTimeoutMs);
    }

    @Override
    public void onUndo(@NonNull View view, int position) {
        super.onUndo(view, position);
        this.cancelCallback(position);
    }

    @Override
    public void onDismiss(@NonNull View view, int position) {
        super.onDismiss(view, position);
        this.cancelCallback(position);
    }

    @Override
    public void dismiss(int position) {
        super.dismiss(position);
        this.cancelCallback(position);
    }

    private void cancelCallback(int position) {
        Runnable timeoutRunnable = this.mRunnables.get(position);
        if (timeoutRunnable != null) {
            this.mHandler.removeCallbacks(timeoutRunnable);
            this.mRunnables.remove(position);
        }
    }

    @Override
    public void onDismiss(@NonNull ViewGroup listView, @NonNull int[] reverseSortedPositions) {
        super.onDismiss(listView, reverseSortedPositions);
        HashMap<Integer, TimeoutRunnable> newRunnables = new HashMap<Integer, TimeoutRunnable>();
        for (int position : reverseSortedPositions) {
            for (int key : this.mRunnables.keySet()) {
                TimeoutRunnable runnable = this.mRunnables.get(key);
                if (key > position) {
                    runnable.setPosition(--key);
                    newRunnables.put(key, runnable);
                    continue;
                }
                if (key == position) continue;
                newRunnables.put(key, runnable);
            }
            this.mRunnables.clear();
            this.mRunnables.putAll(newRunnables);
            newRunnables.clear();
        }
    }

    private class TimeoutRunnable
    implements Runnable {
        private int mPosition;

        TimeoutRunnable(int position) {
            this.mPosition = position;
        }

        @Override
        public void run() {
            TimedUndoAdapter.this.dismiss(this.mPosition);
        }

        public int getPosition() {
            return this.mPosition;
        }

        public void setPosition(int position) {
            this.mPosition = position;
        }
    }
}

