/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.triad;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.nhaarman.triad.Screen;
import com.nhaarman.triad.TransitionAnimator;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;

public class Backstack
implements Iterable<Screen<?>> {
    @NonNull
    private final Deque<Entry<?>> mBackstack;

    private Backstack(@NonNull Deque<Entry<?>> backstack) {
        this.mBackstack = backstack;
    }

    @Override
    public Iterator<Screen<?>> iterator() {
        return new ReadIterator(this.mBackstack.iterator());
    }

    public Iterator<Screen<?>> reverseIterator() {
        return new ReadIterator(this.mBackstack.descendingIterator());
    }

    public Iterator<Entry<?>> reverseEntryIterator() {
        return new EntryReadIterator(this.mBackstack.descendingIterator());
    }

    public int size() {
        return this.mBackstack.size();
    }

    @NonNull
    <T> Entry<T> current() {
        return this.mBackstack.peek();
    }

    public Builder buildUpon() {
        return new Builder(this.mBackstack);
    }

    public String toString() {
        return this.mBackstack.toString();
    }

    public static Builder emptyBuilder() {
        return new Builder(Collections.emptyList());
    }

    public static Backstack single(@NonNull Screen<?> screen) {
        return Backstack.emptyBuilder().push(screen).build();
    }

    public static Backstack single(@NonNull Screen<?> screen, @Nullable TransitionAnimator animator) {
        return Backstack.emptyBuilder().push(screen, animator).build();
    }

    public static Backstack of(Screen<?> ... screens) {
        Builder builder = Backstack.emptyBuilder();
        for (Screen<?> screen : screens) {
            builder.push(screen);
        }
        return builder.build();
    }

    private static class EntryReadIterator
    implements Iterator<Entry<?>> {
        private final Iterator<Entry<?>> mIterator;

        EntryReadIterator(Iterator<Entry<?>> iterator) {
            this.mIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public Entry<?> next() {
            return this.mIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReadIterator
    implements Iterator<Screen<?>> {
        private final Iterator<Entry<?>> mIterator;

        ReadIterator(Iterator<Entry<?>> iterator) {
            this.mIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public Screen<?> next() {
            return this.mIterator.next().screen;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Builder {
        @NonNull
        private final Deque<Entry<?>> mBackstack;

        Builder(@NonNull Collection<Entry<?>> backstack) {
            this.mBackstack = new ArrayDeque(backstack);
        }

        @NonNull
        public Builder push(@NonNull Screen<?> screen) {
            return this.push(screen, null);
        }

        @NonNull
        public Builder push(@NonNull Screen<?> screen, @Nullable TransitionAnimator animator) {
            return this.push(new Entry(screen, animator));
        }

        @NonNull
        public Builder push(@NonNull Entry<?> entry) {
            this.mBackstack.push(entry);
            return this;
        }

        @Nullable
        Entry<?> pop() {
            return this.mBackstack.pop();
        }

        @NonNull
        public Builder clear() {
            this.mBackstack.clear();
            return this;
        }

        @NonNull
        public Backstack build() {
            return new Backstack(this.mBackstack);
        }
    }

    static class Entry<T> {
        @NonNull
        final Screen<T> screen;
        @Nullable
        final TransitionAnimator animator;

        Entry(@NonNull Screen<T> screen, @Nullable TransitionAnimator animator) {
            this.screen = screen;
            this.animator = animator;
        }
    }
}

