/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.triad;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.nhaarman.triad.TransitionAnimator;
import com.nhaarman.triad.Triad;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultTransitionAnimator
implements TransitionAnimator {
    public static final DefaultTransitionAnimator INSTANCE = new DefaultTransitionAnimator();

    private DefaultTransitionAnimator() {
    }

    @Override
    public boolean forward(@Nullable View oldView, @NotNull View newView, @NotNull ViewGroup parent, @NotNull Triad.Callback callback) {
        this.executeAlphaTransition(oldView, newView, parent, callback);
        return true;
    }

    @Override
    public boolean backward(@Nullable View oldView, @NotNull View newView, @NotNull ViewGroup parent, @NotNull Triad.Callback callback) {
        this.executeAlphaTransition(oldView, newView, parent, callback);
        return true;
    }

    private void executeAlphaTransition(final @Nullable View oldView, @NonNull View newView, final @NonNull ViewGroup parent, final @NonNull Triad.Callback callback) {
        int durationMs = parent.getContext().getResources().getInteger(0x10E0000);
        parent.addView(newView);
        if (oldView != null) {
            oldView.animate().alpha(0.0f).setDuration((long)durationMs);
        }
        newView.setAlpha(0.0f);
        newView.animate().alpha(1.0f).setDuration((long)durationMs).withEndAction(new Runnable(){

            @Override
            public void run() {
                if (oldView != null) {
                    parent.removeView(oldView);
                }
                callback.onComplete();
            }
        });
    }
}

