/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.triad;

import org.jetbrains.annotations.NonNls;

final class Preconditions {
    private static final Object[] NO_ARGS = new Object[0];

    private Preconditions() {
    }

    static <T> T checkNotNull(T reference, @NonNls String errorMessage) {
        return Preconditions.checkNotNull(reference, errorMessage, NO_ARGS);
    }

    static <T> T checkNotNull(T reference, @NonNls String errorMessage, Object ... args) {
        if (reference == null) {
            throw new NullPointerException(String.format(errorMessage, args));
        }
        return reference;
    }

    static void checkArgument(boolean condition, @NonNls String errorMessage) {
        Preconditions.checkArgument(condition, errorMessage, NO_ARGS);
    }

    static void checkArgument(boolean condition, @NonNls String errorMessage, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(errorMessage, args));
        }
    }

    static void checkState(boolean expression, @NonNls String errorMessage) {
        Preconditions.checkState(expression, errorMessage, NO_ARGS);
    }

    static void checkState(boolean expression, @NonNls String errorMessage, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(String.format(errorMessage, args));
        }
    }
}

