/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.triad;

import android.app.Activity;
import android.content.Context;
import android.os.Parcelable;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.nhaarman.triad.Preconditions;
import com.nhaarman.triad.Presenter;

public abstract class Screen<ApplicationComponent> {
    @NonNull
    private final SparseArray<Presenter<?, ?>> presenters = new SparseArray();
    @NonNull
    private final SparseArray<Parcelable> state = new SparseArray();
    @Nullable
    private ApplicationComponent applicationComponent;

    @LayoutRes
    protected abstract int getLayoutResId();

    @NonNull
    protected View createView(@NonNull ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutResId(), parent, false);
    }

    @NonNull
    public Presenter<?, ?> getPresenter(int viewId) {
        Presenter<?, ?> presenter = (Presenter<?, ?>)this.presenters.get(viewId);
        if (presenter == null) {
            presenter = this.createPresenter(viewId);
            this.presenters.put(viewId, presenter);
        }
        return presenter;
    }

    @NonNull
    protected abstract Presenter<?, ?> createPresenter(int var1);

    final void setApplicationComponent(@Nullable ApplicationComponent applicationComponent) {
        this.applicationComponent = applicationComponent;
    }

    @NonNull
    protected final ApplicationComponent getApplicationComponent() {
        return Preconditions.checkNotNull(this.applicationComponent, "Application component is null.");
    }

    final void saveState(@NonNull View view) {
        view.saveHierarchyState(this.state);
    }

    final void restoreState(@NonNull View view) {
        view.restoreHierarchyState(this.state);
    }

    protected void onCreate() {
    }

    protected void onAttach(@NonNull Activity activity) {
    }

    protected boolean onBackPressed() {
        return false;
    }

    protected void onDetach(@NonNull Activity activity) {
    }

    protected void onDestroy() {
    }
}

