/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.triad;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.nhaarman.triad.ActivityComponentProvider;
import com.nhaarman.triad.OnScreenChangedListener;
import com.nhaarman.triad.Screen;
import com.nhaarman.triad.ScreenProvider;
import com.nhaarman.triad.Triad;
import com.nhaarman.triad.TriadDelegate;

public abstract class TriadActivity<ApplicationComponent, ActivityComponent>
extends Activity
implements ScreenProvider<ApplicationComponent>,
ActivityComponentProvider<ActivityComponent> {
    @NonNull
    private final TriadDelegate<ApplicationComponent> delegate = TriadDelegate.createFor(this);
    @Nullable
    private ActivityComponent activityComponent;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.delegate.onCreate();
    }

    protected void onResume() {
        super.onResume();
        this.delegate.onResume();
    }

    @Override
    @NonNull
    public synchronized ActivityComponent getActivityComponent() {
        if (this.activityComponent == null) {
            this.activityComponent = this.createActivityComponent();
        }
        return this.activityComponent;
    }

    @NonNull
    protected abstract ActivityComponent createActivityComponent();

    @Override
    @NonNull
    public Screen<ApplicationComponent> getCurrentScreen() {
        return this.delegate.getCurrentScreen();
    }

    public void onBackPressed() {
        if (!this.delegate.onBackPressed()) {
            super.onBackPressed();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.delegate.onActivityResult(requestCode, resultCode, data);
    }

    protected void onPause() {
        this.delegate.onPause();
        super.onPause();
    }

    protected void onDestroy() {
        this.delegate.onDestroy();
        super.onDestroy();
    }

    @NonNull
    protected Triad getTriad() {
        return this.delegate.getTriad();
    }

    protected void setOnScreenChangedListener(@Nullable OnScreenChangedListener<ApplicationComponent> onScreenChangedListener) {
        this.delegate.setOnScreenChangedListener(onScreenChangedListener);
    }
}

