/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.triad;

import android.app.Application;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.nhaarman.triad.ApplicationComponentProvider;
import com.nhaarman.triad.Preconditions;
import com.nhaarman.triad.Triad;
import com.nhaarman.triad.TriadFactory;
import com.nhaarman.triad.TriadProvider;

public abstract class TriadApplication<ApplicationComponent>
extends Application
implements TriadProvider,
ApplicationComponentProvider<ApplicationComponent> {
    @Nullable
    private Triad mTriad;
    @Nullable
    private ApplicationComponent mApplicationComponent;

    public void onCreate() {
        super.onCreate();
        this.mTriad = TriadFactory.emptyInstance();
        this.mApplicationComponent = this.createApplicationComponent();
    }

    @NonNull
    protected abstract ApplicationComponent createApplicationComponent();

    @Override
    @NonNull
    public final Triad getTriad() {
        Preconditions.checkState(this.mTriad != null, "Calling getTriad() before onCreate().");
        return this.mTriad;
    }

    @Override
    @NonNull
    public final ApplicationComponent getApplicationComponent() {
        Preconditions.checkState(this.mApplicationComponent != null, "Calling getApplicationComponent() before onCreate().");
        return this.mApplicationComponent;
    }
}

