/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.triad;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewManager;
import com.nhaarman.triad.ApplicationComponentProvider;
import com.nhaarman.triad.DefaultTransitionAnimator;
import com.nhaarman.triad.OnScreenChangedListener;
import com.nhaarman.triad.Preconditions;
import com.nhaarman.triad.Screen;
import com.nhaarman.triad.TransitionAnimator;
import com.nhaarman.triad.Triad;
import com.nhaarman.triad.TriadProvider;
import java.util.Iterator;

public class TriadDelegate<ApplicationComponent> {
    @NonNull
    private final Activity activity;
    @NonNull
    private final TransitionAnimator defaultTransitionAnimator;
    private boolean resumed = false;
    @Nullable
    private ApplicationComponent applicationComponent;
    @Nullable
    private Triad triad;
    @Nullable
    private ViewGroup rootView;
    @Nullable
    private Screen<ApplicationComponent> currentScreen;
    @Nullable
    private OnScreenChangedListener<ApplicationComponent> onScreenChangedListener;

    private TriadDelegate(@NonNull Activity activity, @NonNull TransitionAnimator transitionAnimator) {
        this.activity = activity;
        this.defaultTransitionAnimator = transitionAnimator;
    }

    @NonNull
    public Screen<ApplicationComponent> getCurrentScreen() {
        return Preconditions.checkNotNull(this.currentScreen, "Current screen is null.");
    }

    public void onCreate() {
        Preconditions.checkState(this.activity.getApplication() instanceof TriadProvider, "Make sure your Application class implements TriadProvider.");
        Preconditions.checkState(this.activity.getApplication() instanceof ApplicationComponentProvider, "Make sure your Application class implements ApplicationComponentProvider.");
        this.applicationComponent = ((ApplicationComponentProvider)this.activity.getApplication()).getApplicationComponent();
        this.rootView = (ViewGroup)this.activity.findViewById(0x1020002);
        this.triad = ((TriadProvider)this.activity.getApplication()).getTriad();
        this.triad.setActivity(this.activity);
        this.triad.setListener(new MyTriadListener());
        if (this.triad.getBackstack().size() > 0 || this.triad.isTransitioning()) {
            this.triad.showCurrent();
        }
    }

    public void onResume() {
        if (this.currentScreen != null) {
            this.currentScreen.onAttach(this.activity);
        }
        this.resumed = true;
    }

    public boolean onBackPressed() {
        Preconditions.checkState(this.triad != null, "Triad is null. Make sure to call TriadDelegate.onCreate().");
        return this.currentScreen != null && this.currentScreen.onBackPressed() || this.triad.goBack();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Preconditions.checkState(this.triad != null, "Triad is null. Make sure to call TriadDelegate.onCreate()");
        this.triad.onActivityResult(requestCode, resultCode, data);
    }

    public void onPause() {
        this.resumed = false;
        if (this.currentScreen != null) {
            this.currentScreen.onDetach(this.activity);
        }
    }

    public void onDestroy() {
        Preconditions.checkState(this.triad != null, "Triad is null. Make sure to call TriadDelegate.onCreate()");
        if (!this.activity.isFinishing()) {
            return;
        }
        Iterator<Screen<?>> iterator = this.triad.getBackstack().reverseIterator();
        while (iterator.hasNext()) {
            Screen<?> screen = iterator.next();
            screen.onDestroy();
        }
    }

    @NonNull
    public Triad getTriad() {
        Preconditions.checkState(this.triad != null, "Triad is null. Make sure to call TriadDelegate.onCreate().");
        return this.triad;
    }

    public void setOnScreenChangedListener(@Nullable OnScreenChangedListener<ApplicationComponent> onScreenChangedListener) {
        this.onScreenChangedListener = onScreenChangedListener;
    }

    private void onScreenChanged(@NonNull Screen<ApplicationComponent> screen) {
        if (this.onScreenChangedListener != null) {
            this.onScreenChangedListener.onScreenChanged(screen);
        }
    }

    @NonNull
    public static <T> TriadDelegate<T> createFor(@NonNull Activity activity) {
        return new TriadDelegate(activity, DefaultTransitionAnimator.INSTANCE);
    }

    @NonNull
    public static <T> TriadDelegate<T> createFor(@NonNull Activity activity, @NonNull TransitionAnimator defaultTransitionAnimator) {
        return new TriadDelegate(activity, defaultTransitionAnimator);
    }

    private class MyTriadListener
    implements Triad.Listener<ApplicationComponent> {
        private MyTriadListener() {
        }

        @Override
        public void screenPushed(@NonNull Screen<ApplicationComponent> pushedScreen) {
            Preconditions.checkState(TriadDelegate.this.applicationComponent != null, "ApplicationComponent is null. Make sure to call TriadDelegate.onCreate().");
            pushedScreen.setApplicationComponent(TriadDelegate.this.applicationComponent);
            pushedScreen.onCreate();
            if (TriadDelegate.this.resumed) {
                pushedScreen.onAttach(TriadDelegate.this.activity);
            }
        }

        @Override
        public void screenPopped(@NonNull Screen<ApplicationComponent> poppedScreen) {
            if (TriadDelegate.this.resumed) {
                poppedScreen.onDetach(TriadDelegate.this.activity);
            }
            poppedScreen.onDestroy();
        }

        @Override
        public void forward(@NonNull Screen<ApplicationComponent> newScreen, @Nullable TransitionAnimator animator, final @NonNull Triad.Callback callback) {
            Preconditions.checkState(TriadDelegate.this.rootView != null, "Root view is null. Make sure to call TriadDelegate.onCreate().");
            final View oldView = TriadDelegate.this.rootView.getChildAt(0);
            if (oldView != null && TriadDelegate.this.currentScreen != null) {
                TriadDelegate.this.currentScreen.saveState(oldView);
            }
            TriadDelegate.this.currentScreen = newScreen;
            View newView = newScreen.createView(TriadDelegate.this.rootView);
            boolean handled = false;
            if (animator != null) {
                handled = animator.forward(oldView, newView, TriadDelegate.this.rootView, new Triad.Callback(){

                    @Override
                    public void onComplete() {
                        if (oldView != null && oldView.getParent() != null) {
                            ((ViewManager)oldView.getParent()).removeView(oldView);
                            callback.onComplete();
                        }
                    }
                });
            }
            if (!handled) {
                TriadDelegate.this.defaultTransitionAnimator.forward(oldView, newView, TriadDelegate.this.rootView, callback);
            }
            TriadDelegate.this.onScreenChanged(newScreen);
        }

        @Override
        public void backward(@NonNull Screen<ApplicationComponent> newScreen, @Nullable TransitionAnimator animator, final @NonNull Triad.Callback callback) {
            Preconditions.checkState(TriadDelegate.this.rootView != null, "Root view is null. Make sure to call TriadDelegate.onCreate().");
            TriadDelegate.this.currentScreen = newScreen;
            final View oldView = TriadDelegate.this.rootView.getChildAt(0);
            View newView = newScreen.createView(TriadDelegate.this.rootView);
            newScreen.restoreState(newView);
            boolean handled = false;
            if (animator != null) {
                handled = animator.backward(oldView, newView, TriadDelegate.this.rootView, new Triad.Callback(){

                    @Override
                    public void onComplete() {
                        if (oldView != null && oldView.getParent() != null) {
                            ((ViewManager)oldView.getParent()).removeView(oldView);
                            callback.onComplete();
                        }
                    }
                });
            }
            if (!handled) {
                TriadDelegate.this.defaultTransitionAnimator.backward(oldView, newView, TriadDelegate.this.rootView, callback);
            }
            TriadDelegate.this.onScreenChanged(newScreen);
        }

        @Override
        public void replace(@NonNull Screen<ApplicationComponent> newScreen, @Nullable TransitionAnimator animator, final @NonNull Triad.Callback callback) {
            Preconditions.checkState(TriadDelegate.this.rootView != null, "Root view is null. Make sure to call TriadDelegate.onCreate().");
            TriadDelegate.this.currentScreen = newScreen;
            final View oldView = TriadDelegate.this.rootView.getChildAt(0);
            View newView = newScreen.createView(TriadDelegate.this.rootView);
            boolean handled = false;
            if (animator != null) {
                handled = animator.forward(oldView, newView, TriadDelegate.this.rootView, new Triad.Callback(){

                    @Override
                    public void onComplete() {
                        if (oldView != null && oldView.getParent() != null) {
                            ((ViewManager)oldView.getParent()).removeView(oldView);
                            callback.onComplete();
                        }
                    }
                });
            }
            if (!handled) {
                TriadDelegate.this.defaultTransitionAnimator.forward(oldView, newView, TriadDelegate.this.rootView, callback);
            }
            TriadDelegate.this.onScreenChanged(newScreen);
        }
    }
}

