/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.triad;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.nhaarman.triad.Backstack;
import com.nhaarman.triad.Preconditions;
import com.nhaarman.triad.Screen;
import com.nhaarman.triad.TransitionAnimator;
import com.nhaarman.triad.Triad;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;

class TriadImpl
implements Triad {
    @NonNull
    private final SparseArray<Triad.ActivityResultListener> activityResultListeners;
    @Nullable
    private Triad.Listener listener;
    @NonNull
    private Backstack backstack;
    @Nullable
    private Transition transition;
    @NonNull
    private WeakReference<Activity> activity;
    private int requestCodeCounter;

    private TriadImpl(@NonNull Backstack backstack) {
        this(backstack, null);
    }

    private TriadImpl(@NonNull Backstack backstack, @Nullable Triad.Listener<?> listener) {
        this.listener = listener;
        this.backstack = backstack;
        this.activityResultListeners = new SparseArray();
        this.activity = new WeakReference<Object>(null);
    }

    @Override
    public void setActivity(@Nullable Activity activity) {
        this.activity = new WeakReference<Activity>(activity);
    }

    @Override
    public void setListener(@Nullable Triad.Listener<?> listener) {
        this.listener = listener;
    }

    @Override
    @NonNull
    public Backstack getBackstack() {
        return this.backstack;
    }

    @Override
    public boolean isTransitioning() {
        return this.transition != null && !this.transition.isFinished();
    }

    @Override
    public void startWith(@NonNull Screen<?> screen) {
        this.startWith(screen, null);
    }

    @Override
    public void startWith(@NonNull Screen<?> screen, @Nullable TransitionAnimator animator) {
        if (this.backstack.size() == 0 && this.transition == null) {
            this.move(new StartWithTransition(screen, animator));
        }
    }

    @Override
    public void startWith(@NonNull Backstack backstack) {
        if (this.backstack.size() == 0 && this.transition == null) {
            this.move(new StartWithBackstackTransition(backstack));
        }
    }

    @Override
    public void goTo(@NonNull Screen<?> screen) {
        this.goTo(screen, null);
    }

    @Override
    public void goTo(@NonNull Screen<?> screen, @Nullable TransitionAnimator animator) {
        Preconditions.checkState(this.backstack.size() > 0 || this.transition != null, "Use startWith(Screen) to show your first Screen.");
        this.move(new GoToTransition(screen, animator));
    }

    @Override
    public void showCurrent() {
        if (this.transition != null && !this.transition.isFinished()) {
            this.transition.cancel();
            this.move(this.transition.copy());
        } else {
            this.move(new ShowTransition());
        }
    }

    @Override
    public void popTo(@NonNull Screen<?> screen) {
        this.popTo(screen, null);
    }

    @Override
    public void popTo(@NonNull Screen<?> screen, @Nullable TransitionAnimator animator) {
        Preconditions.checkState(this.backstack.size() > 0 || this.transition != null, "Use startWith(Screen) to show your first Screen.");
        this.move(new PopToTransition(screen, animator));
    }

    @Override
    public void replaceWith(@NonNull Screen<?> screen) {
        this.replaceWith(screen, null);
    }

    @Override
    public void replaceWith(@NonNull Screen<?> screen, @Nullable TransitionAnimator animator) {
        Preconditions.checkState(this.backstack.size() > 0 || this.transition != null, "Use startWith(Screen) to show your first Screen.");
        this.move(new ReplaceWithTransition(screen, animator));
    }

    @Override
    public boolean goBack() {
        Preconditions.checkState(this.backstack.size() > 0 || this.transition != null, "Use startWith(Screen) to show your first Screen.");
        boolean canGoBack = this.backstack.size() > 1 || this.transition != null && !this.transition.isFinished();
        this.move(new GoBackTransition());
        return canGoBack;
    }

    @Override
    public void forward(@NonNull Backstack newBackstack) {
        Preconditions.checkState(this.backstack.size() > 0 || this.transition != null, "Use startWith(Screen) to show your first Screen.");
        this.move(new ForwardTransition(newBackstack));
    }

    @Override
    public void backward(@NonNull Backstack newBackstack) {
        Preconditions.checkState(this.backstack.size() > 0 || this.transition != null, "Use startWith(Screen) to show your first Screen.");
        this.move(new BackwardTransition(newBackstack));
    }

    @Override
    public void replace(@NonNull Backstack newBackstack) {
        this.replace(newBackstack, null);
    }

    @Override
    public void replace(@NonNull Backstack newBackstack, @Nullable TransitionAnimator animator) {
        Preconditions.checkState(this.backstack.size() > 0 || this.transition != null, "Use startWith(Screen) to show your first Screen.");
        this.move(new ReplaceTransition(newBackstack));
    }

    @Override
    public boolean canStart(@NonNull Intent intent) {
        Activity activity = (Activity)this.activity.get();
        if (activity != null) {
            List infoList = activity.getPackageManager().queryIntentActivities(intent, 0);
            return !infoList.isEmpty();
        }
        return false;
    }

    @Override
    public void startActivity(@NonNull Intent intent) {
        Preconditions.checkState(this.activity.get() != null, "Activity reference is null.");
        ((Activity)this.activity.get()).startActivity(intent);
    }

    @Override
    public void startActivityForResult(@NonNull Intent intent, @NonNull Triad.ActivityResultListener listener) {
        Preconditions.checkState(this.activity.get() != null, "Activity reference is null.");
        ((Activity)this.activity.get()).startActivityForResult(intent, this.requestCodeCounter);
        this.activityResultListeners.put(this.requestCodeCounter, (Object)listener);
        ++this.requestCodeCounter;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        ((Triad.ActivityResultListener)this.activityResultListeners.get(requestCode)).onActivityResult(resultCode, data);
        this.activityResultListeners.remove(requestCode);
    }

    private void move(@NonNull Transition transition) {
        if (this.transition == null || this.transition.isFinished() || this.transition.isCancelled()) {
            this.transition = transition;
            transition.execute();
        } else {
            this.transition.enqueue(transition);
        }
    }

    @NonNull
    public static Triad emptyInstance() {
        return new TriadImpl(Backstack.emptyBuilder().build());
    }

    @NonNull
    public static Triad newInstance(@NonNull Backstack backstack, @NonNull Triad.Listener<?> listener) {
        return new TriadImpl(backstack, listener);
    }

    private class ReplaceTransition
    extends Transition {
        @NonNull
        private final Backstack newBackstack;

        private ReplaceTransition(Backstack newBackstack) {
            this.newBackstack = newBackstack;
        }

        @Override
        public void execute() {
            for (Screen<?> screen : TriadImpl.this.backstack) {
                this.notifyScreenPopped(screen);
            }
            Iterator<Screen<?>> it = this.newBackstack.reverseIterator();
            while (it.hasNext()) {
                this.notifyScreenPushed(it.next());
            }
            this.notifyReplace(this.newBackstack);
        }

        @Override
        public Transition copy() {
            return new ReplaceTransition(this.newBackstack);
        }
    }

    private class BackwardTransition
    extends Transition {
        @NonNull
        private final Backstack newBackstack;

        private BackwardTransition(Backstack newBackstack) {
            this.newBackstack = newBackstack;
        }

        @Override
        public void execute() {
            for (Screen<?> screen : TriadImpl.this.backstack) {
                this.notifyScreenPopped(screen);
            }
            Iterator<Screen<?>> it = this.newBackstack.reverseIterator();
            while (it.hasNext()) {
                this.notifyScreenPushed(it.next());
            }
            this.notifyBackward(this.newBackstack, null);
        }

        @Override
        public Transition copy() {
            return new BackwardTransition(this.newBackstack);
        }
    }

    private class GoToTransition
    extends Transition {
        @NonNull
        private final Screen<?> screen;
        @Nullable
        private final TransitionAnimator animator;

        private GoToTransition(@Nullable Screen<?> screen, TransitionAnimator animator) {
            this.screen = screen;
            this.animator = animator;
        }

        @Override
        public void execute() {
            Backstack newBackstack = TriadImpl.this.backstack.buildUpon().push(this.screen, this.animator).build();
            this.notifyScreenPushed(this.screen);
            this.notifyForward(newBackstack);
        }

        @Override
        public Transition copy() {
            return new GoToTransition(this.screen, this.animator);
        }
    }

    private class StartWithBackstackTransition
    extends Transition {
        @NonNull
        private final Backstack backstack;

        private StartWithBackstackTransition(Backstack backstack) {
            this.backstack = backstack;
        }

        @Override
        public void execute() {
            Iterator<Screen<?>> iterator = this.backstack.reverseIterator();
            while (iterator.hasNext()) {
                this.notifyScreenPushed(iterator.next());
            }
            this.notifyForward(this.backstack);
        }

        @Override
        public Transition copy() {
            return new StartWithBackstackTransition(this.backstack);
        }
    }

    private class StartWithTransition
    extends Transition {
        @NonNull
        private final Screen<?> screen;
        @Nullable
        private final TransitionAnimator animator;

        private StartWithTransition(@Nullable Screen<?> screen, TransitionAnimator animator) {
            this.screen = screen;
            this.animator = animator;
        }

        @Override
        public void execute() {
            Backstack newBackstack = Backstack.single(this.screen, this.animator);
            this.notifyScreenPushed(this.screen);
            this.notifyForward(newBackstack);
        }

        @Override
        public Transition copy() {
            return new StartWithTransition(this.screen, this.animator);
        }
    }

    private class ShowTransition
    extends Transition {
        private ShowTransition() {
        }

        @Override
        public void execute() {
            this.notifyForward(TriadImpl.this.backstack);
        }

        @Override
        public Transition copy() {
            return new ShowTransition();
        }
    }

    private class PopToTransition
    extends Transition {
        @NonNull
        private final Screen<?> screen;
        @Nullable
        private final TransitionAnimator animator;

        private PopToTransition(@Nullable Screen<?> screen, TransitionAnimator animator) {
            this.screen = screen;
            this.animator = animator;
        }

        @Override
        public void execute() {
            Backstack newBackstack;
            Backstack poppedBackstack;
            Backstack.Entry<?> entry;
            if (((TriadImpl)TriadImpl.this).backstack.current().screen.equals(this.screen)) {
                this.onComplete();
                return;
            }
            Backstack.Builder builder = TriadImpl.this.backstack.buildUpon();
            Backstack.Builder poppedScreens = Backstack.emptyBuilder();
            int count = 0;
            Iterator<Backstack.Entry<?>> it = TriadImpl.this.backstack.reverseEntryIterator();
            while (it.hasNext()) {
                Screen screen = it.next().screen;
                if (screen.equals(this.screen)) {
                    for (int i = 0; i < TriadImpl.this.backstack.size() - count; ++i) {
                        entry = builder.pop();
                        if (entry == null) continue;
                        poppedScreens.push(entry);
                    }
                    break;
                }
                ++count;
            }
            if ((poppedBackstack = poppedScreens.build()).size() != 0) {
                Iterator<Backstack.Entry<?>> it2 = poppedBackstack.reverseEntryIterator();
                while (it2.hasNext()) {
                    entry = it2.next();
                    this.notifyScreenPopped(entry.screen);
                }
                builder.push(poppedBackstack.current());
                newBackstack = builder.build();
                this.notifyBackward(newBackstack, this.animator);
            } else {
                this.notifyScreenPushed(this.screen);
                builder.push(this.screen, this.animator);
                newBackstack = builder.build();
                this.notifyForward(newBackstack);
            }
        }

        @Override
        public Transition copy() {
            return new PopToTransition(this.screen, this.animator);
        }
    }

    private class ForwardTransition
    extends Transition {
        @NonNull
        private final Backstack newBackstack;

        private ForwardTransition(Backstack newBackstack) {
            this.newBackstack = newBackstack;
        }

        @Override
        public void execute() {
            for (Screen<?> screen : TriadImpl.this.backstack) {
                this.notifyScreenPopped(screen);
            }
            Iterator<Screen<?>> it = this.newBackstack.reverseIterator();
            while (it.hasNext()) {
                this.notifyScreenPushed(it.next());
            }
            this.notifyForward(this.newBackstack);
        }

        @Override
        public Transition copy() {
            return new ForwardTransition(this.newBackstack);
        }
    }

    private class ReplaceWithTransition
    extends Transition {
        @NonNull
        private final Screen<?> screen;
        @Nullable
        private final TransitionAnimator animator;

        private ReplaceWithTransition(@Nullable Screen<?> screen, TransitionAnimator animator) {
            this.screen = screen;
            this.animator = animator;
        }

        @Override
        public void execute() {
            Backstack.Builder builder = TriadImpl.this.backstack.buildUpon();
            Backstack.Entry<?> entry = Preconditions.checkNotNull(builder.pop(), "Popped entry is null");
            builder.push(this.screen, this.animator);
            Backstack newBackstack = builder.build();
            this.notifyScreenPopped(entry.screen);
            this.notifyScreenPushed(this.screen);
            this.notifyReplace(newBackstack);
        }

        @Override
        public Transition copy() {
            return new ReplaceWithTransition(this.screen, this.animator);
        }
    }

    private class GoBackTransition
    extends Transition {
        private GoBackTransition() {
        }

        @Override
        public void execute() {
            if (TriadImpl.this.backstack.size() == 1) {
                this.onComplete();
            } else {
                Backstack.Builder builder = TriadImpl.this.backstack.buildUpon();
                Backstack.Entry<?> entry = Preconditions.checkNotNull(builder.pop(), "Popped entry is null.");
                Backstack newBackstack = builder.build();
                this.notifyScreenPopped(entry.screen);
                this.notifyBackward(newBackstack, entry.animator);
            }
        }

        @Override
        public Transition copy() {
            return new GoBackTransition();
        }
    }

    private abstract class Transition
    implements Triad.Callback {
        private boolean finished;
        private boolean cancelled;
        @Nullable
        private Transition next;
        @Nullable
        private Backstack nextBackstack;

        private Transition() {
        }

        void enqueue(@NonNull Transition transition) {
            if (this.next == null) {
                this.next = transition;
            } else {
                this.next.enqueue(transition);
            }
        }

        protected void notifyScreenPopped(@NonNull Screen<?> screen) {
            if (this.cancelled) {
                return;
            }
            Preconditions.checkState(TriadImpl.this.listener != null, "Listener is null. Be sure to call setListener(Listener).");
            TriadImpl.this.listener.screenPopped(screen);
        }

        protected void notifyScreenPushed(@NonNull Screen<?> screen) {
            if (this.cancelled) {
                return;
            }
            Preconditions.checkState(TriadImpl.this.listener != null, "Listener is null. Be sure to call setListener(Listener).");
            TriadImpl.this.listener.screenPushed(screen);
        }

        protected void notifyForward(@NonNull Backstack nextBackstack) {
            if (this.cancelled) {
                return;
            }
            Preconditions.checkState(TriadImpl.this.listener != null, "Listener is null. Be sure to call setListener(Listener).");
            this.nextBackstack = nextBackstack;
            TriadImpl.this.listener.forward(nextBackstack.current().screen, nextBackstack.current().animator, this);
        }

        protected void notifyBackward(@NonNull Backstack nextBackstack, @Nullable TransitionAnimator animator) {
            if (this.cancelled) {
                return;
            }
            Preconditions.checkState(TriadImpl.this.listener != null, "Listener is null. Be sure to call setListener(Listener).");
            this.nextBackstack = nextBackstack;
            TriadImpl.this.listener.backward(nextBackstack.current().screen, animator, this);
        }

        protected void notifyReplace(@NonNull Backstack nextBackstack) {
            if (this.cancelled) {
                return;
            }
            Preconditions.checkState(TriadImpl.this.listener != null, "Listener is null. Be sure to call setListener(Listener).");
            this.nextBackstack = nextBackstack;
            TriadImpl.this.listener.replace(nextBackstack.current().screen, nextBackstack.current().animator, this);
        }

        protected abstract void execute();

        @Override
        public void onComplete() {
            if (this.cancelled) {
                return;
            }
            Preconditions.checkState(!this.finished, "onComplete already called for this transition");
            if (this.nextBackstack != null) {
                TriadImpl.this.backstack = this.nextBackstack;
            }
            this.finished = true;
            if (this.next != null) {
                TriadImpl.this.transition = this.next;
                TriadImpl.this.transition.execute();
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[finished=" + this.finished + "]";
        }

        public abstract Transition copy();
    }
}

