/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.dflib.csv;

import com.nhl.dflib.DataFrame;
import com.nhl.dflib.Index;
import com.nhl.dflib.Series;
import com.nhl.dflib.csv.CsvLoaderWorker;
import com.nhl.dflib.csv.loader.ColumnBuilder;
import java.util.Iterator;
import org.apache.commons.csv.CSVRecord;

class BaseCsvLoaderWorker
implements CsvLoaderWorker {
    protected ColumnBuilder<?>[] columnAccumulators;
    protected Index columnIndex;

    BaseCsvLoaderWorker(Index columnIndex, ColumnBuilder<?>[] columnAccumulators) {
        this.columnIndex = columnIndex;
        this.columnAccumulators = columnAccumulators;
    }

    @Override
    public DataFrame load(Iterator<CSVRecord> it) {
        this.consumeCSV(it);
        return this.toDataFrame();
    }

    protected void consumeCSV(Iterator<CSVRecord> it) {
        int width = this.columnIndex.size();
        while (it.hasNext()) {
            this.addRow(width, it.next());
        }
    }

    protected DataFrame toDataFrame() {
        int width = this.columnIndex.size();
        Series[] columns = new Series[width];
        for (int i = 0; i < width; ++i) {
            columns[i] = this.columnAccumulators[i].toColumn();
        }
        return DataFrame.newFrame((Index)this.columnIndex).columns(columns);
    }

    protected void addRow(int width, CSVRecord row) {
        for (int i = 0; i < width; ++i) {
            this.columnAccumulators[i].add(row);
        }
    }
}

