/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.dflib.csv;

import com.nhl.dflib.DataFrame;
import com.nhl.dflib.DoubleValueMapper;
import com.nhl.dflib.Index;
import com.nhl.dflib.IntValueMapper;
import com.nhl.dflib.LongValueMapper;
import com.nhl.dflib.ValueMapper;
import com.nhl.dflib.ValuePredicate;
import com.nhl.dflib.csv.BaseCsvLoaderWorker;
import com.nhl.dflib.csv.CsvLoaderWorker;
import com.nhl.dflib.csv.FilteringCsvLoaderWorker;
import com.nhl.dflib.csv.FilteringSamplingCsvLoaderWorker;
import com.nhl.dflib.csv.SamplingCsvLoaderWorker;
import com.nhl.dflib.csv.loader.ColumnBuilder;
import com.nhl.dflib.csv.loader.ColumnConfig;
import com.nhl.dflib.csv.loader.CsvCell;
import com.nhl.dflib.csv.loader.RowFilterConfig;
import com.nhl.dflib.sample.Sampler;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public class CsvLoader {
    private int skipRows;
    private Index header;
    private String[] includeColumns;
    private int[] includeColumnPositions;
    private String[] dropColumns;
    private CSVFormat format = CSVFormat.DEFAULT;
    private int rowSampleSize;
    private Random rowsSampleRandom;
    private final List<ColumnConfig> columns = new ArrayList<ColumnConfig>();
    private final List<RowFilterConfig<?>> rowFilters = new ArrayList();

    public CsvLoader skipRows(int n) {
        this.skipRows = n;
        return this;
    }

    public CsvLoader sampleRows(int size) {
        return this.sampleRows(size, Sampler.getDefaultRandom());
    }

    public CsvLoader sampleRows(int size, Random random) {
        this.rowSampleSize = size;
        this.rowsSampleRandom = Objects.requireNonNull(random);
        return this;
    }

    public <V> CsvLoader selectRows(String columnName, ValuePredicate<V> condition) {
        this.rowFilters.add(RowFilterConfig.create(columnName, condition));
        return this;
    }

    public <V> CsvLoader selectRows(int columnPos, ValuePredicate<V> condition) {
        this.rowFilters.add(RowFilterConfig.create(columnPos, condition));
        return this;
    }

    @Deprecated
    public <V> CsvLoader filterRows(String columnName, ValuePredicate<V> condition) {
        return this.selectRows(columnName, condition);
    }

    @Deprecated
    public <V> CsvLoader filterRows(int columnPos, ValuePredicate<V> condition) {
        return this.selectRows(columnPos, condition);
    }

    public CsvLoader header(String ... columns) {
        this.header = Index.forLabels((String[])columns);
        return this;
    }

    public CsvLoader selectColumns(String ... columns) {
        this.includeColumnPositions = null;
        this.includeColumns = columns;
        return this;
    }

    public CsvLoader selectColumns(int ... columns) {
        this.includeColumnPositions = columns;
        this.includeColumns = null;
        return this;
    }

    public CsvLoader dropColumns(String ... columns) {
        this.dropColumns = columns;
        return this;
    }

    public CsvLoader columnType(int column, ValueMapper<String, ?> mapper) {
        this.columns.add(ColumnConfig.objectColumn(column, mapper));
        return this;
    }

    public CsvLoader columnType(String column, ValueMapper<String, ?> mapper) {
        this.columns.add(ColumnConfig.objectColumn(column, mapper));
        return this;
    }

    public CsvLoader intColumn(int column) {
        this.columns.add(ColumnConfig.intColumn(column));
        return this;
    }

    public CsvLoader intColumn(String column) {
        this.columns.add(ColumnConfig.intColumn(column));
        return this;
    }

    public CsvLoader intColumn(int column, int forNull) {
        this.columns.add(ColumnConfig.intColumn(column, (IntValueMapper<String>)IntValueMapper.fromString((int)forNull)));
        return this;
    }

    public CsvLoader intColumn(String column, int forNull) {
        this.columns.add(ColumnConfig.intColumn(column, (IntValueMapper<String>)IntValueMapper.fromString((int)forNull)));
        return this;
    }

    public CsvLoader longColumn(int column) {
        this.columns.add(ColumnConfig.longColumn(column));
        return this;
    }

    public CsvLoader longColumn(String column) {
        this.columns.add(ColumnConfig.longColumn(column));
        return this;
    }

    public CsvLoader longColumn(int column, long forNull) {
        this.columns.add(ColumnConfig.longColumn(column, (LongValueMapper<String>)LongValueMapper.fromString((long)forNull)));
        return this;
    }

    public CsvLoader longColumn(String column, long forNull) {
        this.columns.add(ColumnConfig.longColumn(column, (LongValueMapper<String>)LongValueMapper.fromString((long)forNull)));
        return this;
    }

    public CsvLoader doubleColumn(int column) {
        this.columns.add(ColumnConfig.doubleColumn(column));
        return this;
    }

    public CsvLoader doubleColumn(String column) {
        this.columns.add(ColumnConfig.doubleColumn(column));
        return this;
    }

    public CsvLoader doubleColumn(int column, double forNull) {
        this.columns.add(ColumnConfig.doubleColumn(column, (DoubleValueMapper<String>)DoubleValueMapper.fromString((double)forNull)));
        return this;
    }

    public CsvLoader doubleColumn(String column, double forNull) {
        this.columns.add(ColumnConfig.doubleColumn(column, (DoubleValueMapper<String>)DoubleValueMapper.fromString((double)forNull)));
        return this;
    }

    public CsvLoader booleanColumn(int column) {
        this.columns.add(ColumnConfig.booleanColumn(column));
        return this;
    }

    public CsvLoader booleanColumn(String column) {
        this.columns.add(ColumnConfig.booleanColumn(column));
        return this;
    }

    public CsvLoader numColumn(int column, Class<? extends Number> type) {
        return this.columnType(column, this.numericMapper(type));
    }

    public CsvLoader numColumn(String column, Class<? extends Number> type) {
        return this.columnType(column, this.numericMapper(type));
    }

    private ValueMapper<String, ?> numericMapper(Class<? extends Number> type) {
        if (Integer.class.equals(type)) {
            return ValueMapper.stringToInt();
        }
        if (Long.class.equals(type)) {
            return ValueMapper.stringToLong();
        }
        if (Double.class.equals(type)) {
            return ValueMapper.stringToDouble();
        }
        if (Float.class.equals(type)) {
            return ValueMapper.stringToFloat();
        }
        if (BigDecimal.class.equals(type)) {
            return ValueMapper.stringToBigDecimal();
        }
        if (BigInteger.class.equals(type)) {
            return ValueMapper.stringToBigInteger();
        }
        throw new IllegalArgumentException("Can't map numeric type to a string converter: " + type);
    }

    public CsvLoader dateColumn(int column) {
        return this.columnType(column, ValueMapper.stringToDate());
    }

    public CsvLoader dateColumn(String column) {
        return this.columnType(column, ValueMapper.stringToDate());
    }

    public CsvLoader dateTimeColumn(int column) {
        return this.columnType(column, ValueMapper.stringToDateTime());
    }

    public CsvLoader dateTimeColumn(String column) {
        return this.columnType(column, ValueMapper.stringToDateTime());
    }

    public CsvLoader dateColumn(int column, DateTimeFormatter formatter) {
        return this.columnType(column, ValueMapper.stringToDate((DateTimeFormatter)formatter));
    }

    public CsvLoader dateColumn(String column, DateTimeFormatter formatter) {
        return this.columnType(column, ValueMapper.stringToDate((DateTimeFormatter)formatter));
    }

    public CsvLoader dateTimeColumn(int column, DateTimeFormatter formatter) {
        return this.columnType(column, ValueMapper.stringToDateTime((DateTimeFormatter)formatter));
    }

    public CsvLoader dateTimeColumn(String column, DateTimeFormatter formatter) {
        return this.columnType(column, ValueMapper.stringToDateTime((DateTimeFormatter)formatter));
    }

    public CsvLoader format(CSVFormat format) {
        this.format = format;
        return this;
    }

    public CsvLoader emptyStringIsNull() {
        this.format = this.format.withNullString("");
        return this;
    }

    public DataFrame load(Path filePath) {
        return this.load(filePath.toFile());
    }

    public DataFrame load(File file) {
        DataFrame dataFrame;
        FileReader r = new FileReader(file);
        try {
            dataFrame = this.load(r);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading file: " + file, e);
            }
        }
        ((Reader)r).close();
        return dataFrame;
    }

    public DataFrame load(String filePath) {
        DataFrame dataFrame;
        FileReader r = new FileReader(filePath);
        try {
            dataFrame = this.load(r);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading file: " + filePath, e);
            }
        }
        ((Reader)r).close();
        return dataFrame;
    }

    public DataFrame load(Reader reader) {
        try {
            Iterator<CSVRecord> it = this.createRecordIterator(reader);
            ColumnMap columnMap = this.createColumnMap(it);
            if (!it.hasNext()) {
                return DataFrame.newFrame((Index)columnMap.dfHeader).empty();
            }
            ColumnConfig[] unfilteredColumns = ColumnConfig.normalize(columnMap.csvHeader, this.columns);
            CsvLoaderWorker worker = this.rowSampleSize > 0 ? this.samplingWorker(columnMap, unfilteredColumns) : this.noSamplingWorker(columnMap, unfilteredColumns);
            return worker.load(it);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading CSV", e);
        }
    }

    private CsvLoaderWorker noSamplingWorker(ColumnMap columnMap, ColumnConfig[] csvColumns) {
        return this.rowFilters.isEmpty() ? new BaseCsvLoaderWorker(columnMap.dfHeader, columnMap.createAccumulators(csvColumns)) : new FilteringCsvLoaderWorker(columnMap.dfHeader, columnMap.createAccumulators(csvColumns), columnMap.createValueHolders(csvColumns), this.createRowFilter(columnMap.csvHeader));
    }

    private CsvLoaderWorker samplingWorker(ColumnMap columnMap, ColumnConfig[] csvColumns) {
        return this.rowFilters.isEmpty() ? new SamplingCsvLoaderWorker(columnMap.dfHeader, columnMap.createAccumulators(csvColumns), this.rowSampleSize, this.rowsSampleRandom) : new FilteringSamplingCsvLoaderWorker(columnMap.dfHeader, columnMap.createAccumulators(csvColumns), columnMap.createValueHolders(csvColumns), this.createRowFilter(columnMap.csvHeader), this.rowSampleSize, this.rowsSampleRandom);
    }

    private Iterator<CSVRecord> createRecordIterator(Reader reader) throws IOException {
        Iterator it = this.format.parse(reader).iterator();
        for (int i = 0; i < this.skipRows && it.hasNext(); ++i) {
            it.next();
        }
        return it;
    }

    private ColumnMap createColumnMap(Iterator<CSVRecord> it) {
        return this.createColumnMap(this.createCsvHeader(it));
    }

    private ColumnMap createColumnMap(Index csvHeader) {
        int uw = csvHeader.size();
        if (this.includeColumns == null && this.includeColumnPositions == null && this.dropColumns == null) {
            int[] positions = new int[uw];
            for (int i = 0; i < positions.length; ++i) {
                positions[i] = i;
            }
            return new ColumnMap(csvHeader, csvHeader, positions);
        }
        ArrayList<String> columns = new ArrayList<String>(uw);
        ArrayList<Integer> positions = new ArrayList<Integer>(uw);
        if (this.includeColumns != null) {
            for (String includeColumn : this.includeColumns) {
                columns.add(includeColumn);
                positions.add(csvHeader.position(includeColumn));
            }
        } else if (this.includeColumnPositions != null) {
            for (int includeColumnPosition : this.includeColumnPositions) {
                columns.add(csvHeader.getLabel(includeColumnPosition));
                positions.add(includeColumnPosition);
            }
        } else {
            for (int i = 0; i < uw; ++i) {
                columns.add(csvHeader.getLabel(i));
                positions.add(i);
            }
        }
        if (this.dropColumns != null) {
            for (String toDrop : this.dropColumns) {
                int i = columns.indexOf(toDrop);
                if (i < 0) continue;
                columns.remove(i);
                positions.remove(i);
            }
        }
        Index dfHeader = Index.forLabels((String[])columns.toArray(new String[0]));
        int[] csvPositions = new int[positions.size()];
        for (int i = 0; i < csvPositions.length; ++i) {
            csvPositions[i] = (Integer)positions.get(i);
        }
        return new ColumnMap(csvHeader, dfHeader, csvPositions);
    }

    private Index createCsvHeader(Iterator<CSVRecord> it) {
        if (it.hasNext()) {
            return this.header != null ? this.header : this.loadCsvHeader(it.next());
        }
        return this.header != null ? this.header : Index.forLabels((String[])new String[0]);
    }

    private Index loadCsvHeader(CSVRecord header) {
        int width = header.size();
        String[] columnNames = new String[width];
        for (int i = 0; i < width; ++i) {
            columnNames[i] = header.get(i);
        }
        return Index.forLabels((String[])columnNames);
    }

    private Predicate<CsvCell<?>[]> createRowFilter(Index columns) {
        if (this.rowFilters.isEmpty()) {
            return c -> true;
        }
        Predicate<CsvCell<?>[]> p = this.rowFilters.get(0).toPredicate(columns);
        for (int i = 1; i < this.rowFilters.size(); ++i) {
            p = p.and(this.rowFilters.get(i).toPredicate(columns));
        }
        return p;
    }

    private static class ColumnMap {
        Index csvHeader;
        Index dfHeader;
        int[] csvPositions;

        ColumnMap(Index csvHeader, Index dfHeader, int[] csvPositions) {
            this.csvHeader = csvHeader;
            this.dfHeader = dfHeader;
            this.csvPositions = csvPositions;
        }

        ColumnBuilder<?>[] createAccumulators(ColumnConfig[] csvColumns) {
            int w = this.dfHeader.size();
            ColumnBuilder[] accums = new ColumnBuilder[w];
            for (int i = 0; i < w; ++i) {
                accums[i] = csvColumns[this.csvPositions[i]].createAccumulatorColumn(this.csvPositions[i]);
            }
            return accums;
        }

        CsvCell<?>[] createValueHolders(ColumnConfig[] csvColumns) {
            int w = this.csvHeader.size();
            CsvCell[] holders = new CsvCell[w];
            for (int i = 0; i < w; ++i) {
                holders[i] = csvColumns[i].createValueHolderColumn(i);
            }
            return holders;
        }
    }
}

